/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tweaks.module;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.TWEAKS)
public class DiamondRepairModule
extends QuarkModule {
    @Config(name="Repair Item Changes", description="List of changes to apply to repair items, format is \"<item>=<repair_item>\" as seen in the defualt.\nMultiple repair items can be applied for the same base item, and as long as at least one is provided, any vanilla option will be removed.\nTo use multiple items, comma separate them (e.g. \"minecraft:diamond_sword=minecraft:diamond,minecraft:emerald\")If you want the vanilla option back, you must add it again manually.")
    public static List<String> repairChangesList = Arrays.asList("minecraft:netherite_sword=minecraft:diamond", "minecraft:netherite_pickaxe=minecraft:diamond", "minecraft:netherite_axe=minecraft:diamond", "minecraft:netherite_shovel=minecraft:diamond", "minecraft:netherite_hoe=minecraft:diamond", "minecraft:netherite_helmet=minecraft:diamond", "minecraft:netherite_chestplate=minecraft:diamond", "minecraft:netherite_leggings=minecraft:diamond", "minecraft:netherite_boots=minecraft:diamond");
    @Config(name="Unrepairable Items")
    public static List<String> unrepairableItemsList = Arrays.asList(new String[0]);
    @Config
    private static boolean enableJeiHints = true;
    private static boolean staticEnabled;
    public static Multimap<Item, Item> repairChanges;
    public static List<Item> unrepairableItems;

    @Override
    public void configChanged() {
        staticEnabled = this.enabled;
        repairChanges.clear();
        for (String s : repairChangesList) {
            String[] repairToks;
            ResourceLocation itemRes;
            String[] toks = s.split("=");
            if (toks.length != 2 || !ForgeRegistries.ITEMS.containsKey(itemRes = new ResourceLocation(toks[0]))) continue;
            String repairItems = toks[1];
            for (String repairTok : repairToks = repairItems.split(",")) {
                ResourceLocation repairItemRes = new ResourceLocation(repairTok);
                if (!ForgeRegistries.ITEMS.containsKey(repairItemRes)) continue;
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemRes);
                Item repairItem = (Item)ForgeRegistries.ITEMS.getValue(repairItemRes);
                repairChanges.put((Object)item, (Object)repairItem);
            }
        }
        unrepairableItems = MiscUtil.massRegistryGet(unrepairableItemsList, ForgeRegistries.ITEMS);
    }

    @Override
    public void addAdditionalHints(BiConsumer<Item, Component> consumer) {
        if (!enableJeiHints) {
            return;
        }
        MutableComponent removed = Component.m_237115_((String)"quark.jei.hint.repair_item_removed");
        for (Item item : unrepairableItems) {
            consumer.accept(item, (Component)removed);
        }
        for (Item item : repairChanges.keySet()) {
            Collection options = repairChanges.get((Object)item);
            int len = options.size();
            String key = "quark.jei.hint.repair_item_changed" + (len == 1 ? "" : "_multiple");
            MutableComponent formatParams = Component.m_237119_();
            int i = 1;
            for (Item repair : options) {
                formatParams = formatParams.m_7220_(repair.m_7626_(new ItemStack((ItemLike)repair)));
                if (i < len) {
                    formatParams = formatParams.m_7220_((Component)Component.m_237113_((String)", "));
                }
                ++i;
            }
            consumer.accept(item, (Component)Component.m_237110_((String)key, (Object[])new Object[]{formatParams}));
        }
    }

    public static boolean isValidRepairItem(boolean prev, Item item, ItemStack repairItem) {
        if (staticEnabled) {
            if (unrepairableItems.contains(item)) {
                return false;
            }
            if (repairChanges.containsKey((Object)item)) {
                return repairChanges.get((Object)item).contains(repairItem.m_41720_());
            }
        }
        return prev;
    }

    static {
        repairChanges = HashMultimap.create();
    }
}

