/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.client.renderer;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import li.cil.scannable.client.ScanManager;
import li.cil.scannable.client.renderer.forge.ScannerRendererImpl;
import li.cil.scannable.client.shader.Shaders;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

@OnlyIn(value=Dist.CLIENT)
public enum ScannerRenderer {
    INSTANCE;

    private DepthOnlyRenderTarget mainCameraDepth = new DepthOnlyRenderTarget(854, 480);
    private long currentStart;
    private Vec3 currentCenter;

    public void ping(Vec3 pos) {
        this.currentStart = System.currentTimeMillis();
        this.currentCenter = pos;
    }

    public static void render(PoseStack poseStack) {
        INSTANCE.doRender(poseStack);
    }

    public void doRender(PoseStack poseStack) {
        if (this.shouldRender()) {
            this.grabDepthBuffer();
            this.render(poseStack.m_85850_().m_85861_());
        }
    }

    private boolean shouldRender() {
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        return this.currentStart > 0L && adjustedDuration > (int)(System.currentTimeMillis() - this.currentStart);
    }

    private void grabDepthBuffer() {
        RenderTarget mainRenderTarget = Minecraft.m_91087_().m_91385_();
        if (mainRenderTarget.f_83915_ != this.mainCameraDepth.f_83915_ || mainRenderTarget.f_83916_ != this.mainCameraDepth.f_83916_) {
            this.mainCameraDepth.m_83941_(mainRenderTarget.f_83915_, mainRenderTarget.f_83916_, Minecraft.f_91002_);
        }
        this.mainCameraDepth = ScannerRenderer.copyBufferSettings(mainRenderTarget, this.mainCameraDepth);
        this.mainCameraDepth.m_83945_(mainRenderTarget);
        mainRenderTarget.m_83947_(false);
    }

    private void render(Matrix4f viewMatrix) {
        ShaderInstance shader = Shaders.getScanEffectShader();
        if (shader == null) {
            return;
        }
        RenderTarget target = Minecraft.m_91087_().m_91385_();
        this.updateShaderUniforms(shader, viewMatrix);
        this.blit(target);
    }

    private void updateShaderUniforms(ShaderInstance shader, Matrix4f viewMatrix) {
        Matrix4f invertedViewMatrix = new Matrix4f(viewMatrix);
        invertedViewMatrix.m_27657_();
        Matrix4f invertedProjectionMatrix = new Matrix4f(RenderSystem.m_157192_());
        invertedProjectionMatrix.m_27657_();
        Vec3 cameraPosition = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        int adjustedDuration = ScanManager.computeScanGrowthDuration();
        float radius = ScanManager.computeRadius(this.currentStart, adjustedDuration);
        shader.m_173350_("depthTex", (Object)this.mainCameraDepth.m_83980_());
        shader.m_173356_("center").m_142276_(new Vector3f(this.currentCenter));
        shader.m_173356_("invViewMat").m_5679_(invertedViewMatrix);
        shader.m_173356_("invProjMat").m_5679_(invertedProjectionMatrix);
        shader.m_173356_("pos").m_142276_(new Vector3f(cameraPosition));
        shader.m_173356_("radius").m_5985_(radius);
    }

    private void blit(RenderTarget target) {
        int width = target.f_83915_;
        int height = target.f_83916_;
        RenderSystem.m_69458_((boolean)false);
        RenderSystem.m_69465_();
        RenderSystem.m_69478_();
        ShaderInstance oldShader = RenderSystem.m_157196_();
        RenderSystem.m_157427_(Shaders::getScanEffectShader);
        RenderSystem.m_157183_();
        RenderSystem.m_157425_((Matrix4f)Matrix4f.m_162203_((float)0.0f, (float)width, (float)0.0f, (float)height, (float)1.0f, (float)100.0f));
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)height, -50.0).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)width, (double)height, -50.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_((double)width, 0.0, -50.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, -50.0).m_7421_(0.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
        RenderSystem.m_157424_();
        RenderSystem.m_157427_(() -> oldShader);
        RenderSystem.m_69458_((boolean)true);
        RenderSystem.m_69482_();
        RenderSystem.m_69461_();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static DepthOnlyRenderTarget copyBufferSettings(RenderTarget mainRenderTarget, DepthOnlyRenderTarget depthRenderTarget) {
        void var1_1;
        return ScannerRendererImpl.copyBufferSettings(mainRenderTarget, (DepthOnlyRenderTarget)var1_1);
    }

    public static final class DepthOnlyRenderTarget
    extends TextureTarget {
        public DepthOnlyRenderTarget(int width, int height) {
            super(width, height, true, Minecraft.f_91002_);
        }

        public void m_83950_(int width, int height, boolean isOnOSX) {
            super.m_83950_(width, height, isOnOSX);
            if (this.f_83923_ > -1) {
                if (this.f_83920_ > -1) {
                    GL30.glBindFramebuffer((int)36160, (int)this.f_83920_);
                    GL11.glDrawBuffer((int)0);
                    GL30.glBindFramebuffer((int)36160, (int)0);
                }
                TextureUtil.m_85281_((int)this.f_83923_);
                this.f_83923_ = -1;
            }
        }
    }
}

