/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.container;

import li.cil.scannable.common.container.Containers;
import li.cil.scannable.common.container.ScannerSlot;
import li.cil.scannable.common.inventory.ContainerSlice;
import li.cil.scannable.common.inventory.ScannerContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public final class ScannerContainerMenu
extends AbstractContainerMenu {
    private final Player player;
    private final InteractionHand hand;
    private final ItemStack stack;

    public static ScannerContainerMenu create(int windowId, Inventory inventory, FriendlyByteBuf buffer) {
        InteractionHand hand = (InteractionHand)buffer.m_130066_(InteractionHand.class);
        return new ScannerContainerMenu(windowId, inventory, hand, new ScannerContainer(inventory.f_35978_.m_21120_(hand)));
    }

    public ScannerContainerMenu(int windowId, Inventory inventory, InteractionHand hand, ScannerContainer itemHandler) {
        super((MenuType)Containers.SCANNER_CONTAINER.get(), windowId);
        int slot;
        this.player = inventory.f_35978_;
        this.hand = hand;
        this.stack = this.player.m_21120_(hand);
        ContainerSlice activeModules = itemHandler.getActiveModules();
        for (int slot2 = 0; slot2 < activeModules.m_6643_(); ++slot2) {
            this.m_38897_(new ScannerSlot(activeModules, slot2, 62 + slot2 * 18, 20));
        }
        ContainerSlice storedModules = itemHandler.getInactiveModules();
        for (slot = 0; slot < storedModules.m_6643_(); ++slot) {
            this.m_38897_(new ScannerSlot(storedModules, slot, 62 + slot * 18, 46));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new ScannerSlot((Container)inventory, col + row * 9 + 9, 8 + col * 18, row * 18 + 77));
            }
        }
        for (slot = 0; slot < 9; ++slot) {
            this.m_38897_(new ScannerSlot((Container)inventory, slot, 8 + slot * 18, 135));
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public boolean m_6875_(Player player) {
        return player == this.player && ItemStack.m_41728_((ItemStack)player.m_21120_(this.hand), (ItemStack)this.stack);
    }

    public ItemStack m_7648_(Player player, int index) {
        Slot into;
        int i;
        int step;
        Slot from = (Slot)this.f_38839_.get(index);
        ItemStack stack = from.m_7993_().m_41777_();
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        boolean intoPlayerInventory = from.f_40218_ != player.m_150109_();
        ItemStack fromStack = from.m_7993_();
        if (intoPlayerInventory) {
            step = -1;
            begin = this.f_38839_.size() - 1;
        } else {
            step = 1;
            begin = 0;
        }
        if (fromStack.m_41741_() > 1) {
            for (i = begin; i >= 0 && i < this.f_38839_.size(); i += step) {
                int itemsMoved;
                int maxSizeInSlot;
                int spaceInSlot;
                boolean itemsAreEqual;
                ItemStack intoStack;
                into = (Slot)this.f_38839_.get(i);
                if (into.f_40218_ == from.f_40218_ || (intoStack = into.m_7993_()).m_41619_()) continue;
                boolean bl = itemsAreEqual = fromStack.m_41656_(intoStack) && ItemStack.m_41658_((ItemStack)fromStack, (ItemStack)intoStack);
                if (!itemsAreEqual || (spaceInSlot = (maxSizeInSlot = Math.min(fromStack.m_41741_(), into.m_5866_(stack))) - intoStack.m_41613_()) <= 0 || (itemsMoved = Math.min(spaceInSlot, fromStack.m_41613_())) <= 0) continue;
                intoStack.m_41769_(from.m_6201_(itemsMoved).m_41613_());
                into.m_6654_();
                if (from.m_7993_().m_41619_()) break;
            }
        }
        for (i = begin; i >= 0 && i < this.f_38839_.size() && !from.m_7993_().m_41619_(); i += step) {
            into = (Slot)this.f_38839_.get(i);
            if (into.f_40218_ == from.f_40218_ || into.m_6657_() || !into.m_5857_(fromStack)) continue;
            int maxSizeInSlot = Math.min(fromStack.m_41741_(), into.m_5866_(fromStack));
            int itemsMoved = Math.min(maxSizeInSlot, fromStack.m_41613_());
            into.m_5852_(from.m_6201_(itemsMoved));
        }
        return from.m_7993_().m_41613_() < stack.m_41613_() ? from.m_7993_() : ItemStack.f_41583_;
    }
}

