/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.common.item;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import li.cil.scannable.api.scanning.ScannerModule;
import li.cil.scannable.common.config.CommonConfig;
import li.cil.scannable.common.config.Strings;
import li.cil.scannable.common.item.ModItem;
import li.cil.scannable.common.item.forge.ScannerModuleItemImpl;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Contract;

public class ScannerModuleItem
extends ModItem {
    private final ScannerModule module;

    ScannerModuleItem(ScannerModule module) {
        super(new Item.Properties().m_41487_(1));
        this.module = module;
    }

    public ScannerModule getModule() {
        return this.module;
    }

    @Contract(value="_ -> !null")
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Optional<ScannerModule> getModule(ItemStack stack) {
        return ScannerModuleItemImpl.getModule(stack);
    }

    public static int getModuleEnergyCost(ItemStack stack) {
        if (!CommonConfig.useEnergy) {
            return 0;
        }
        return ScannerModuleItem.getModule(stack).map(module -> module.getEnergyCost(stack)).orElse(0);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        int cost = ScannerModuleItem.getModuleEnergyCost(stack);
        if (cost > 0) {
            tooltip.add(Strings.energyUsage(cost));
        }
    }
}

