/*
 * Decompiled with CFR 0.152.
 */
package li.cil.scannable.util;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarBuilder;
import dev.architectury.registry.registries.Registries;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;

public final class RegistryUtils {
    private static final List<DeferredRegister<?>> ENTRIES = new ArrayList();
    private static Phase phase = Phase.PRE_INIT;
    private static String modId;

    @SafeVarargs
    public static <T> RegistrarBuilder<T> builder(ResourceKey<Registry<T>> registryKey, T ... typeGetter) {
        return Registries.get((String)modId).builder(registryKey.m_135782_(), (Object[])typeGetter);
    }

    public static <T> DeferredRegister<T> get(ResourceKey<Registry<T>> registryKey) {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        DeferredRegister entry = DeferredRegister.create((String)modId, registryKey);
        ENTRIES.add(entry);
        return entry;
    }

    public static void begin(String modId) {
        RegistryUtils.modId = modId;
        if (phase != Phase.PRE_INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.INIT;
    }

    public static void finish() {
        if (phase != Phase.INIT) {
            throw new IllegalStateException();
        }
        phase = Phase.POST_INIT;
        for (DeferredRegister<?> register : ENTRIES) {
            register.register();
        }
        ENTRIES.clear();
    }

    private RegistryUtils() {
    }

    private static enum Phase {
        PRE_INIT,
        INIT,
        POST_INIT;

    }
}

