/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.container;

import com.google.common.collect.Range;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.IContainerDataListener;
import mcjty.lib.api.container.IGenericContainer;
import mcjty.lib.container.BaseSlot;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.CraftingSlot;
import mcjty.lib.container.GhostOutputSlot;
import mcjty.lib.container.GhostSlot;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.container.SlotFactory;
import mcjty.lib.container.SlotRanges;
import mcjty.lib.container.SlotType;
import mcjty.lib.network.PacketContainerDataToClient;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkDirection;

public class GenericContainer
extends AbstractContainerMenu
implements IGenericContainer {
    protected final Map<String, IItemHandler> inventories = new HashMap<String, IItemHandler>();
    private final Map<ResourceLocation, IContainerDataListener> containerData = new HashMap<ResourceLocation, IContainerDataListener>();
    private final ContainerFactory factory;
    protected final BlockPos pos;
    protected final GenericTileEntity te;
    private final List<DataSlot> intReferenceHolders = new ArrayList<DataSlot>();
    private boolean doForce = true;
    private final Player player;

    public GenericContainer(@Nullable MenuType<?> type, int id, ContainerFactory factory, BlockPos pos, @Nullable GenericTileEntity te, @Nonnull Player player) {
        super(type, id);
        this.factory = factory;
        this.pos = pos;
        this.te = te;
        this.player = player;
    }

    public GenericContainer(@Nonnull Supplier<MenuType<GenericContainer>> type, int id, @Nonnull Supplier<ContainerFactory> factory, @Nullable GenericTileEntity te, @Nonnull Player player) {
        super(type.get(), id);
        this.factory = factory.get();
        this.pos = te.m_58899_();
        this.te = te;
        this.player = player;
    }

    @Override
    public AbstractContainerMenu getAsContainer() {
        return this;
    }

    public GenericTileEntity getTe() {
        return this.te;
    }

    public Player getPlayer() {
        return this.player;
    }

    @Nonnull
    protected DataSlot m_38895_(@Nonnull DataSlot holder) {
        this.intReferenceHolders.add(holder);
        return super.m_38895_(holder);
    }

    @Override
    public void addShortListener(DataSlot holder) {
        this.m_38895_(holder);
    }

    @Override
    public void addIntegerListener(final DataSlot holder) {
        this.m_38895_(new DataSlot(){
            private int lastKnown;

            public int m_6501_() {
                return holder.m_6501_() & 0xFFFF;
            }

            public void m_6422_(int val) {
                int full = holder.m_6501_();
                holder.m_6422_(full & 0xFFFF0000 | val & 0xFFFF);
            }

            public boolean m_39409_() {
                int i = this.m_6501_();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
        this.m_38895_(new DataSlot(){
            private int lastKnown;

            public int m_6501_() {
                return holder.m_6501_() >> 16 & 0xFFFF;
            }

            public void m_6422_(int val) {
                int full = holder.m_6501_();
                holder.m_6422_(full & 0xFFFF | (val & 0xFFFF) << 16);
            }

            public boolean m_39409_() {
                int i = this.m_6501_();
                boolean flag = i != this.lastKnown;
                this.lastKnown = i;
                return flag;
            }
        });
    }

    @Override
    public void addContainerDataListener(IContainerDataListener data) {
        this.containerData.put(data.getId(), data);
    }

    public void addInventory(String name, @Nullable IItemHandler inventory) {
        if (inventory != null) {
            this.inventories.put(name, inventory);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IItemHandler getInventory(String name) {
        return this.inventories.get(name);
    }

    public boolean m_6875_(@Nonnull Player player) {
        return this.te == null || this.te.canPlayerAccess(player);
    }

    public SlotType getSlotType(int index) {
        return this.factory.getSlotType(index);
    }

    @Nullable
    public Slot getSlotByInventoryAndIndex(String name, int index) {
        IItemHandler inv = this.inventories.get(name);
        if (inv == null) {
            return null;
        }
        for (Slot slot : this.f_38839_) {
            IItemHandler itemHandler;
            if (!(slot instanceof SlotItemHandler) || (itemHandler = ((SlotItemHandler)slot).getItemHandler()) != inv || slot.getSlotIndex() != index) continue;
            return slot;
        }
        return null;
    }

    @Override
    public void setupInventories(IItemHandler itemHandler, Inventory inventory) {
        this.addInventory("container", itemHandler);
        this.addInventory("player", (IItemHandler)new InvWrapper((Container)inventory));
        this.generateSlots(inventory.f_35978_);
    }

    public void generateSlots(Player player) {
        for (SlotFactory slotFactory : this.factory.getSlots()) {
            IItemHandler inventory = this.inventories.get(slotFactory.inventoryName());
            int index = slotFactory.index();
            int x = slotFactory.x();
            int y = slotFactory.y();
            SlotType slotType = slotFactory.getSlotType();
            Slot slot = this.createSlot(slotFactory, player, inventory, index, x, y, slotType);
            this.m_38897_(slot);
        }
    }

    protected Slot createSlot(SlotFactory slotFactory, Player playerEntity, IItemHandler inventory, int index, int x, int y, SlotType slotType) {
        SlotItemHandler slot;
        if (slotType == SlotType.SLOT_GHOST) {
            slot = new GhostSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_GHOSTOUT) {
            slot = new GhostOutputSlot(inventory, index, x, y);
        } else if (slotType == SlotType.SLOT_SPECIFICITEM) {
            final SlotDefinition slotDefinition = slotFactory.slotDefinition();
            slot = new SlotItemHandler(inventory, index, x, y){

                public boolean m_5857_(@Nonnull ItemStack stack) {
                    return slotDefinition.itemStackMatches(stack);
                }
            };
        } else {
            slot = slotType == SlotType.SLOT_CRAFTRESULT ? new CraftingSlot(playerEntity, inventory, this.te, index, x, y).onCraft(slotFactory.slotDefinition().getOnCraft()) : new BaseSlot(inventory, this.te, index, x, y);
        }
        return slot;
    }

    private boolean mergeItemStacks(ItemStack itemStack, SlotType slotType, boolean reverse) {
        if (slotType == SlotType.SLOT_SPECIFICITEM) {
            return this.mergeItemStacks(itemStack, (SlotDefinition definition) -> definition.isSpecific() && definition.itemStackMatches(itemStack), reverse);
        }
        return this.mergeItemStacks(itemStack, (SlotDefinition definition) -> definition.getType() == slotType, reverse);
    }

    private boolean mergeItemStacks(ItemStack itemStack, Predicate<SlotDefinition> slotType, boolean reverse) {
        SlotRanges ranges = this.factory.getRanges(slotType);
        Set<Range<Integer>> set = ranges.asRanges();
        if (set.isEmpty()) {
            return false;
        }
        for (Range<Integer> r : ranges.asRanges()) {
            Integer start = (Integer)r.lowerEndpoint();
            int end = (Integer)r.upperEndpoint();
            if (!this.m_38903_(itemStack, start, end, reverse)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack origStack = slot.m_7993_();
            itemstack = origStack.m_41777_();
            if (this.factory.isSpecificItemSlot(index)) {
                if (!this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) && !this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(origStack, itemstack);
            } else if (this.factory.isOutputSlot(index) || this.factory.isInputSlot(index) || this.factory.isGenericSlot(index)) {
                if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, true) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(origStack, itemstack);
            } else {
                if (this.factory.isGhostSlot(index) || this.factory.isGhostOutputSlot(index)) {
                    return ItemStack.f_41583_;
                }
                if (this.factory.isPlayerInventorySlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotDefinition::isInput, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERHOTBAR, false))) {
                        return ItemStack.f_41583_;
                    }
                } else if (this.factory.isPlayerHotbarSlot(index)) {
                    if (!(this.mergeItemStacks(origStack, SlotType.SLOT_SPECIFICITEM, false) || this.mergeItemStacks(origStack, SlotDefinition::isInput, false) || this.mergeItemStacks(origStack, SlotType.SLOT_PLAYERINV, false))) {
                        return ItemStack.f_41583_;
                    }
                } else {
                    Logging.log("Weird slot at index: " + index);
                }
            }
            if (origStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (origStack.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, origStack);
        }
        return itemstack;
    }

    protected boolean m_38903_(@Nonnull ItemStack par1ItemStack, int fromIndex, int toIndex, boolean reverseOrder) {
        int amount;
        Slot slot;
        boolean result = false;
        int checkIndex = fromIndex;
        if (reverseOrder) {
            checkIndex = toIndex - 1;
        }
        ItemStack itemstack1 = ItemStack.f_41583_;
        if (par1ItemStack.m_41753_()) {
            while (!par1ItemStack.m_41619_() && (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex)) {
                slot = (Slot)this.f_38839_.get(checkIndex);
                itemstack1 = slot.m_7993_();
                if (!itemstack1.m_41619_() && itemstack1.m_41720_() == par1ItemStack.m_41720_() && par1ItemStack.m_41773_() == itemstack1.m_41773_() && ItemStack.m_41658_((ItemStack)par1ItemStack, (ItemStack)itemstack1) && slot.m_5857_(par1ItemStack)) {
                    int maxStackSize;
                    int mergedSize = itemstack1.m_41613_() + par1ItemStack.m_41613_();
                    if (mergedSize <= (maxStackSize = Math.min(par1ItemStack.m_41741_(), slot.m_6641_()))) {
                        par1ItemStack.m_41764_(0);
                        itemstack1.m_41764_(Math.max(mergedSize, 0));
                        slot.m_6654_();
                        result = true;
                    } else if (itemstack1.m_41613_() < maxStackSize) {
                        amount = -(maxStackSize - itemstack1.m_41613_());
                        par1ItemStack.m_41769_(amount);
                        itemstack1.m_41764_(Math.max(maxStackSize, 0));
                        slot.m_6654_();
                        result = true;
                    }
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        if (!par1ItemStack.m_41619_()) {
            checkIndex = reverseOrder ? toIndex - 1 : fromIndex;
            while (!reverseOrder && checkIndex < toIndex || reverseOrder && checkIndex >= fromIndex) {
                slot = (Slot)this.f_38839_.get(checkIndex);
                itemstack1 = slot.m_7993_();
                if (itemstack1.m_41619_() && slot.m_5857_(par1ItemStack)) {
                    ItemStack in = par1ItemStack.m_41777_();
                    int amount1 = Math.min(in.m_41613_(), slot.m_6641_());
                    in.m_41764_(Math.max(amount1, 0));
                    slot.m_5852_(in);
                    slot.m_6654_();
                    if (in.m_41613_() >= par1ItemStack.m_41613_()) {
                        par1ItemStack.m_41764_(0);
                    } else {
                        amount = -in.m_41613_();
                        par1ItemStack.m_41769_(amount);
                    }
                    result = true;
                    break;
                }
                if (reverseOrder) {
                    --checkIndex;
                    continue;
                }
                ++checkIndex;
            }
        }
        return result;
    }

    public void m_150399_(int index, int button, @Nonnull ClickType mode, @Nonnull Player player) {
        if (this.factory.isGhostSlot(index)) {
            ItemStack clickedWith;
            Slot slot = this.m_38853_(index);
            if (slot.m_6657_()) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            if (!(clickedWith = this.m_142621_()).m_41619_()) {
                ItemStack copy = clickedWith.m_41777_();
                copy.m_41764_(1);
                slot.m_5852_(copy);
            }
            this.m_38946_();
        } else {
            super.m_150399_(index, button, mode, player);
        }
    }

    public IContainerDataListener getListener(ResourceLocation id) {
        return this.containerData.get(id);
    }

    private void broadcast() {
        for (int i = 0; i < this.intReferenceHolders.size(); ++i) {
            DataSlot holder = this.intReferenceHolders.get(i);
            for (ContainerListener listener : this.f_38848_) {
                listener.m_142153_((AbstractContainerMenu)this, i, holder.m_6501_());
            }
        }
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (IContainerDataListener data : this.containerData.values()) {
                ByteBuf newbuf = Unpooled.buffer();
                FriendlyByteBuf buffer = new FriendlyByteBuf(newbuf);
                data.toBytes(buffer);
                PacketContainerDataToClient packet = new PacketContainerDataToClient(data.getId(), buffer);
                McJtyLib.networkHandler.sendTo((Object)packet, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void forceBroadcast() {
        this.doForce = true;
    }

    public void m_38946_() {
        if (this.doForce) {
            this.broadcast();
            this.doForce = false;
        }
        super.m_38946_();
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            for (IContainerDataListener data : this.containerData.values()) {
                if (!data.isDirtyAndClear()) continue;
                ByteBuf newbuf = Unpooled.buffer();
                FriendlyByteBuf buffer = new FriendlyByteBuf(newbuf);
                data.toBytes(buffer);
                PacketContainerDataToClient packet = new PacketContainerDataToClient(data.getId(), buffer);
                McJtyLib.networkHandler.sendTo((Object)packet, serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public static MenuType<AbstractContainerMenu> createContainerType(String registryName) {
        MenuType containerType = IForgeMenuType.create((windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity te = inv.f_35978_.m_20193_().m_7702_(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (AbstractContainerMenu)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> Objects.requireNonNull(h.m_7208_(windowId, inv, inv.f_35978_))).orElseThrow(RuntimeException::new);
        });
        return containerType;
    }

    public static <T extends AbstractContainerMenu> MenuType<T> createContainerType() {
        MenuType containerType = IForgeMenuType.create((windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            BlockEntity te = inv.f_35978_.m_20193_().m_7702_(pos);
            if (te == null) {
                throw new IllegalStateException("Something went wrong getting the GUI");
            }
            return (AbstractContainerMenu)te.getCapability(CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY).map(h -> Objects.requireNonNull(h.m_7208_(windowId, inv, inv.f_35978_))).orElseThrow(RuntimeException::new);
        });
        return containerType;
    }

    public static <T extends GenericContainer, E extends GenericTileEntity> MenuType<T> createRemoteContainerType(BiFunction<ResourceKey<Level>, BlockPos, E> dummyTEFactory, ContainerSupplier<T, E> containerFactory, int slots) {
        return IForgeMenuType.create((windowId, inv, data) -> {
            BlockPos pos = data.m_130135_();
            GenericTileEntity te = (GenericTileEntity)((Object)((Object)dummyTEFactory.apply(LevelTools.getId(data.m_130281_()), pos)));
            CompoundTag compound = data.m_130260_();
            te.m_142466_(compound);
            Object container = containerFactory.create(windowId, pos, te, inv.f_35978_);
            ((GenericContainer)container).setupInventories((IItemHandler)new ItemStackHandler(slots), inv);
            return container;
        });
    }

    public static interface ContainerSupplier<T extends GenericContainer, E extends GenericTileEntity> {
        public T create(int var1, BlockPos var2, E var3, Player var4);
    }
}

