/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui.icons;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcjty.lib.gui.icons.IIcon;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;

public class ImageIcon
implements IIcon,
Cloneable {
    private ResourceLocation image = null;
    private int u;
    private int v;
    private int width;
    private int height;
    private final String id;
    private List<IIcon> overlays;
    private Map<String, Object> dataMap;

    public ResourceLocation getImage() {
        return this.image;
    }

    public ImageIcon(String id) {
        this.id = id;
    }

    @Override
    public void addOverlay(IIcon icon) {
        if (this.overlays == null) {
            this.overlays = new ArrayList<IIcon>();
        }
        this.overlays.add(icon);
    }

    @Override
    public void removeOverlay(String id) {
        if (this.overlays == null) {
            return;
        }
        IIcon toRemove = null;
        for (IIcon icon : this.overlays) {
            if (!id.equals(icon.getID())) continue;
            toRemove = icon;
            break;
        }
        if (toRemove != null) {
            this.overlays.remove(toRemove);
        }
    }

    @Override
    public boolean hasOverlay(String id) {
        if (this.overlays == null) {
            return false;
        }
        for (IIcon icon : this.overlays) {
            if (!id.equals(icon.getID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearOverlays() {
        this.overlays = null;
    }

    @Override
    public void addData(String name, Object data) {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<String, Object>();
        }
        this.dataMap.put(name, data);
    }

    @Override
    public void removeData(String name) {
        if (this.dataMap == null) {
            return;
        }
        this.dataMap.remove(name);
    }

    @Override
    public void clearData() {
        this.dataMap = null;
    }

    @Override
    public Map<String, Object> getData() {
        return this.dataMap;
    }

    public ImageIcon setImage(ResourceLocation image, int u, int v) {
        this.image = image;
        this.u = u;
        this.v = v;
        return this;
    }

    public ImageIcon setDimensions(int w, int h) {
        this.width = w;
        this.height = h;
        return this;
    }

    @Override
    public void draw(Screen gui, PoseStack matrixStack, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.image);
        gui.m_93228_(matrixStack, x, y, this.u, this.v, this.width, this.height);
        if (this.overlays != null) {
            for (IIcon icon : this.overlays) {
                icon.draw(gui, matrixStack, x, y);
            }
        }
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public IIcon clone() {
        ImageIcon imageIcon = new ImageIcon(this.id).setImage(this.image, this.u, this.v).setDimensions(this.width, this.height);
        if (this.overlays != null) {
            imageIcon.overlays = new ArrayList<IIcon>();
            for (IIcon icon : this.overlays) {
                imageIcon.overlays.add(icon.clone());
            }
        }
        if (this.dataMap != null) {
            imageIcon.dataMap = new HashMap<String, Object>(this.dataMap);
        }
        return imageIcon;
    }
}

