/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.varia;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;

public class LevelTools {
    public static boolean isLoaded(Level world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        return world.m_46805_(pos);
    }

    public static ServerLevel getOverworld() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server.m_129880_(Level.f_46428_);
    }

    public static ServerLevel getOverworld(Level world) {
        MinecraftServer server = world.m_7654_();
        return server.m_129880_(Level.f_46428_);
    }

    public static ServerLevel getLevel(ResourceKey<Level> type) {
        return ServerLifecycleHooks.getCurrentServer().m_129880_(type);
    }

    public static ServerLevel getLevel(Level world, ResourceKey<Level> type) {
        return world.m_7654_().m_129880_(type);
    }

    public static ServerLevel getLevel(Level world, ResourceLocation id) {
        return world.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)id));
    }

    public static ResourceKey<Level> getId(ResourceLocation id) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)id);
    }

    public static ResourceKey<Level> getId(String id) {
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(id));
    }

    public static Stream<ServerPlayer> getAllPlayersWatchingBlock(Level world, BlockPos pos) {
        if (world instanceof ServerLevel) {
            ChunkMap playerManager = ((ServerLevel)world).m_7726_().f_8325_;
            return playerManager.m_183262_(new ChunkPos(pos), false).stream();
        }
        return Stream.empty();
    }
}

