/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.gui.sprite.SpriteTextureMap;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;

public class Sprite
implements ISprite {
    public static final ISprite EMPTY = SpriteTextureMap.EMPTY.sprite().build();
    public static final NonNullSupplier<ISprite> EMPTY_SUPPLIER = () -> EMPTY;
    private final int _width;
    private final int _height;
    private final ISpriteTextureMap _map;
    private final int _u;
    private final int _v;
    private final float _minU;
    private final float _maxU;
    private final float _minV;
    private final float _maxV;
    private final ISprite _overlay;

    public Sprite(ISpriteTextureMap textureMap) {
        this(16, 16, textureMap, 0, 0, null);
    }

    public Sprite(int width, int height, ISpriteTextureMap textureMap) {
        this(width, height, textureMap, 0, 0, null);
    }

    public Sprite(int width, int height, ISpriteTextureMap textureMap, int u, int v) {
        this(width, height, textureMap, u, v, null);
    }

    public Sprite(int width, int height, ISpriteTextureMap textureMap, @Nullable ISprite overlay) {
        this(width, height, textureMap, 0, 0, overlay);
    }

    public Sprite(int width, int height, ISpriteTextureMap textureMap, int u, int v, @Nullable ISprite overlay) {
        this._width = width;
        this._height = height;
        this._map = textureMap;
        this._u = u;
        this._v = v;
        this._overlay = overlay;
        float textureMapWidth = textureMap.getWidth();
        float textureMapHeight = textureMap.getHeight();
        this._minU = (float)this._u / textureMapWidth;
        this._maxU = (float)(this._u + this._width) / textureMapWidth;
        this._minV = (float)this._v / textureMapHeight;
        this._maxV = (float)(this._v + this._height) / textureMapHeight;
    }

    @Override
    public int getU() {
        return this._u;
    }

    @Override
    public int getV() {
        return this._v;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public float getMinU() {
        return this._minU;
    }

    @Override
    public float getMaxU() {
        return this._maxU;
    }

    @Override
    public float getMinV() {
        return this._minV;
    }

    @Override
    public float getMaxV() {
        return this._maxV;
    }

    @Override
    public ISpriteTextureMap getTextureMap() {
        return this._map;
    }

    @Override
    public Optional<ISprite> getSpriteOverlay() {
        return Optional.ofNullable(this._overlay);
    }

    @Override
    public void applyOverlay(NonNullConsumer<ISprite> overlayConsumer) {
        if (null != this._overlay) {
            overlayConsumer.accept((Object)this._overlay);
        }
    }

    @Override
    public ISprite copy() {
        return new Sprite(this);
    }

    @Override
    public ISprite copyWith(ISprite overlay) {
        return new Sprite(this._width, this._height, this._map, this._u, this._v, Objects.requireNonNull(overlay));
    }

    public String toString() {
        return String.format("%d,%d - %d x %d", this.getU(), this.getV(), this.getWidth(), this.getHeight());
    }

    protected Sprite(ISprite other) {
        this._width = other.getWidth();
        this._height = other.getHeight();
        this._map = other.getTextureMap();
        this._u = other.getU();
        this._v = other.getV();
        this._minU = other.getMinU();
        this._maxU = other.getMaxU();
        this._minV = other.getMinV();
        this._maxV = other.getMaxV();
        this._overlay = other.getSpriteOverlay().orElse(null);
    }
}

