/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.unlikepaladin.pfm.blocks.CutleryBlock;
import com.unlikepaladin.pfm.blocks.HorizontalFacingBlockWithEntity;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.blockentities.PlateBlockEntity;
import com.unlikepaladin.pfm.blocks.forge.PlateBlockImpl;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import com.unlikepaladin.pfm.registry.Statistics;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlateBlock
extends HorizontalFacingBlockWithEntity {
    public static final BooleanProperty CUTLERY = BooleanProperty.m_61465_((String)"cutlery");
    private static final List<FurnitureBlock> PLATES = new ArrayList<FurnitureBlock>();
    protected static final VoxelShape PLATE = Shapes.m_83124_((VoxelShape)PlateBlock.m_49796_((double)2.0, (double)0.0, (double)3.0, (double)12.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape PLATE_SOUTH = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.SOUTH, PLATE);
    protected static final VoxelShape PLATE_EAST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.EAST, PLATE);
    protected static final VoxelShape PLATE_WEST = KitchenDrawerBlock.rotateShape(Direction.NORTH, Direction.WEST, PLATE);
    protected final Random random = new Random();

    public PlateBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)CUTLERY, (Comparable)Boolean.valueOf(false)));
        PLATES.add(new FurnitureBlock((Block)this, "plate"));
    }

    public static Stream<FurnitureBlock> streamPlates() {
        return PLATES.stream();
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        PlateBlockEntity plateBlockEntity;
        ItemStack itemStack = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PlateBlockEntity && itemStack.m_41614_()) {
            if (!world.f_46443_ && ((PlateBlockEntity)blockEntity).addItem(player.m_150110_().f_35937_ ? itemStack.m_41777_() : itemStack)) {
                player.m_36220_(Statistics.PLATE_USED);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (Registry.f_122824_.m_7745_(Registry.f_122827_.m_7981_((Object)itemStack.m_41720_())) instanceof CutleryBlock) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)CUTLERY, (Comparable)Boolean.valueOf(true)));
            itemStack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        if (player.m_6144_() && blockEntity instanceof PlateBlockEntity && !(plateBlockEntity = (PlateBlockEntity)blockEntity).getItemInPlate().m_41619_()) {
            if (!world.f_46443_) {
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, plateBlockEntity.removeItem());
                world.m_7967_((Entity)itemEntity);
                player.m_36220_(Statistics.PLATE_USED);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (blockEntity instanceof PlateBlockEntity && !(plateBlockEntity = (PlateBlockEntity)blockEntity).getItemInPlate().m_41619_()) {
            ItemStack stack = plateBlockEntity.getItemInPlate();
            this.spawnItemParticles((LivingEntity)player, stack, 16);
            if (Registry.f_122827_.m_7981_((Object)stack.m_41720_()).toString().equals("sandwichable:sandwich")) {
                PlateBlock.eatSandwich(stack, world, player);
            } else {
                if (!player.m_7500_()) {
                    ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, stack.m_41671_(world, (LivingEntity)player));
                    world.m_7967_((Entity)itemEntity);
                }
                player.m_5584_(world, stack);
            }
            plateBlockEntity.removeItem();
            player.m_36220_(Statistics.PLATE_USED);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, world, pos, player, hand, hit);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void eatSandwich(ItemStack stack, Level world, Player player) {
        void var2_2;
        void var1_1;
        PlateBlockImpl.eatSandwich(stack, (Level)var1_1, (Player)var2_2);
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (((Boolean)state.m_61143_((Property)CUTLERY)).booleanValue() && !player.m_150110_().f_35937_) {
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_CUTLERY, 1));
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return PlateBlock.getBlockEntity(pos, state);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntity getBlockEntity(BlockPos pos, BlockState state) {
        void var1_1;
        return PlateBlockImpl.getBlockEntity(pos, (BlockState)var1_1);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateManager) {
        super.m_7926_(stateManager);
        stateManager.m_61104_(new Property[]{CUTLERY});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            if (((Boolean)state.m_61143_((Property)CUTLERY)).booleanValue()) {
                ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.8, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)PaladinFurnitureModBlocksItems.BASIC_CUTLERY, 1));
                world.m_7967_((Entity)itemEntity);
            }
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter view, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        return switch (dir) {
            case Direction.WEST -> PLATE_SOUTH;
            case Direction.NORTH -> PLATE_WEST;
            case Direction.SOUTH -> PLATE_EAST;
            default -> PLATE;
        };
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (state.m_60713_(newState.m_60734_())) {
            return;
        }
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PlateBlockEntity) {
            PlateBlockEntity plateBlockEntity = (PlateBlockEntity)blockEntity;
            Containers.m_19002_((Level)world, (BlockPos)pos, (Container)plateBlockEntity.getInventory());
            world.m_46717_(pos, (Block)this);
            plateBlockEntity.m_7651_();
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    private void spawnItemParticles(LivingEntity entity, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3d = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3d = vec3d.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            vec3d = vec3d.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            double d = (double)(-this.random.nextFloat()) * 0.6 - 0.3;
            Vec3 vec3d2 = new Vec3(((double)this.random.nextFloat() - 0.5) * 0.3, d, 0.6);
            vec3d2 = vec3d2.m_82496_(-entity.m_146909_() * ((float)Math.PI / 180));
            vec3d2 = vec3d2.m_82524_(-entity.m_146908_() * ((float)Math.PI / 180));
            vec3d2 = vec3d2.m_82520_(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
            entity.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec3d2.f_82479_, vec3d2.f_82480_, vec3d2.f_82481_, vec3d.f_82479_, vec3d.f_82480_ + 0.05, vec3d.f_82481_);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction direction = Direction.DOWN;
        return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_121945_(direction), (Direction)direction.m_122424_());
    }
}

