/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.models.basicLamp.forge;

import com.unlikepaladin.pfm.blocks.BasicLampBlock;
import com.unlikepaladin.pfm.blocks.blockentities.LampBlockEntity;
import com.unlikepaladin.pfm.blocks.models.forge.ModelBitSetProperty;
import com.unlikepaladin.pfm.blocks.models.forge.PFMForgeBakedModel;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgeBasicLampModel
extends PFMForgeBakedModel {
    public static ModelProperty<ModelBitSetProperty> CONNECTIONS = new ModelProperty();
    public static ModelProperty<WoodVariant> VARIANT = new ModelProperty();
    static List<TextureAtlasSprite> oakSprite = new ArrayList<TextureAtlasSprite>();
    Map<WoodVariant, List<TextureAtlasSprite>> sprites = new HashMap<WoodVariant, List<TextureAtlasSprite>>();

    public ForgeBasicLampModel(ModelState settings, List<BakedModel> modelParts) {
        super(settings, modelParts);
    }

    @Override
    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData tileData) {
        if (state.m_60734_() instanceof BasicLampBlock) {
            ModelData.Builder builder = ModelData.builder();
            ModelData data = builder.build();
            data = super.getModelData(world, pos, state, data);
            WoodVariant variant = WoodVariantRegistry.OAK;
            BlockEntity entity = world.m_7702_(pos);
            if (entity instanceof LampBlockEntity) {
                variant = ((LampBlockEntity)entity).getVariant();
            }
            BitSet set = new BitSet();
            set.set(0, world.m_8055_(pos.m_7494_()).m_60734_() instanceof BasicLampBlock);
            set.set(1, world.m_8055_(pos.m_7495_()).m_60734_() instanceof BasicLampBlock);
            data = data.derive().with(CONNECTIONS, (Object)new ModelBitSetProperty(set)).with(VARIANT, (Object)variant).build();
            return data;
        }
        return tileData;
    }

    static List<TextureAtlasSprite> getOakStrippedLogSprite() {
        if (!oakSprite.isEmpty()) {
            return oakSprite;
        }
        TextureAtlasSprite wood = new Material(InventoryMenu.f_39692_, new ResourceLocation("minecraft:block/stripped_oak_log")).m_119204_();
        oakSprite.add(wood);
        return oakSprite;
    }

    List<TextureAtlasSprite> getVariantStrippedLogSprite(WoodVariant variant) {
        if (this.sprites.containsKey(variant)) {
            return this.sprites.get(variant);
        }
        TextureAtlasSprite wood = new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG)).m_119204_();
        ArrayList<TextureAtlasSprite> spriteList = new ArrayList<TextureAtlasSprite>();
        spriteList.add(wood);
        this.sprites.put(variant, spriteList);
        return spriteList;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        if (state != null && extraData.get(CONNECTIONS) != null && ((ModelBitSetProperty)extraData.get(ForgeBasicLampModel.CONNECTIONS)).connections != null) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            int onOffset = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 1 : 0;
            WoodVariant variant = (WoodVariant)extraData.get(VARIANT);
            TextureAtlasSprite sprite = new Material(InventoryMenu.f_39692_, variant.getTexture(BlockType.STRIPPED_LOG)).m_119204_();
            BitSet set = ((ModelBitSetProperty)extraData.get(ForgeBasicLampModel.CONNECTIONS)).connections;
            if (set.get(0) && set.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(1).getQuads(state, side, rand, extraData, renderType));
            } else if (set.get(0)) {
                quads.addAll(this.getTemplateBakedModels().get(0).getQuads(state, side, rand, extraData, renderType));
            } else if (set.get(1)) {
                quads.addAll(this.getTemplateBakedModels().get(3).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(5 + onOffset).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
            } else {
                quads.addAll(this.getTemplateBakedModels().get(4).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(2).getQuads(state, side, rand, extraData, renderType));
                quads.addAll(this.getTemplateBakedModels().get(5 + onOffset).getQuads(state, side, rand, extraData, renderType));
            }
            return this.getQuadsWithTexture(quads, ForgeBasicLampModel.getOakStrippedLogSprite(), this.getVariantStrippedLogSprite(variant));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean m_7521_() {
        return true;
    }

    @Override
    public TextureAtlasSprite getParticleIcon(@NotNull ModelData data) {
        if (data != null && data.has(VARIANT)) {
            return this.getVariantStrippedLogSprite((WoodVariant)data.get(VARIANT)).get(0);
        }
        return super.getParticleIcon(data);
    }

    @Override
    public ItemTransforms m_7442_() {
        return this.getTemplateBakedModels().get(2).m_7442_();
    }

    @Override
    public List<BakedQuad> getQuads(ItemStack stack, @Nullable BlockState state, @Nullable Direction face, RandomSource random) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        WoodVariant variant = WoodVariantRegistry.OAK;
        if (stack.m_41782_()) {
            variant = WoodVariantRegistry.getVariant(ResourceLocation.m_135820_((String)stack.m_41737_("BlockEntityTag").m_128461_("variant")));
        }
        quads.addAll(this.getTemplateBakedModels().get(4).m_213637_(state, face, random));
        quads.addAll(this.getTemplateBakedModels().get(2).m_213637_(state, face, random));
        quads.addAll(this.getTemplateBakedModels().get(5).m_213637_(state, face, random));
        return this.getQuadsWithTexture(quads, ForgeBasicLampModel.getOakStrippedLogSprite(), this.getVariantStrippedLogSprite(variant));
    }
}

