/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.client.EntityRenderIDs;
import com.unlikepaladin.pfm.client.forge.EntityRenderRegistryImpl;
import com.unlikepaladin.pfm.entity.model.ModelEmpty;
import com.unlikepaladin.pfm.entity.render.ChairEntityRenderer;
import com.unlikepaladin.pfm.entity.render.MicrowaveBlockEntityRenderer;
import com.unlikepaladin.pfm.entity.render.PFMBedBlockEntityRenderer;
import com.unlikepaladin.pfm.entity.render.PFMToasterBlockEntityRenderer;
import com.unlikepaladin.pfm.entity.render.PlateBlockEntityRenderer;
import com.unlikepaladin.pfm.entity.render.StovetopBlockEntityRenderer;
import com.unlikepaladin.pfm.entity.render.TrashcanBlockEntityRenderer;
import com.unlikepaladin.pfm.registry.BlockEntities;
import com.unlikepaladin.pfm.registry.Entities;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class EntityRenderRegistry {
    public static void registerBlockEntityRenderers() {
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.MICROWAVE_BLOCK_ENTITY, MicrowaveBlockEntityRenderer::new);
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.STOVE_TOP_BLOCK_ENTITY, StovetopBlockEntityRenderer::new);
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.PLATE_BLOCK_ENTITY, PlateBlockEntityRenderer::new);
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.STOVE_BLOCK_ENTITY, EntityRenderRegistry.getStoveBlockEntityRenderer());
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.TRASHCAN_BLOCK_ENTITY, TrashcanBlockEntityRenderer::new);
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.TOASTER_BLOCK_ENTITY, PFMToasterBlockEntityRenderer::new);
        EntityRenderRegistry.registerBlockEntityRender(BlockEntities.BED_BLOCK_ENTITY, PFMBedBlockEntityRenderer::new);
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> {
            if (pfmModCompatibility.getClientModCompatiblity().isPresent()) {
                pfmModCompatibility.getClientModCompatiblity().get().registerBlockEntityRenderer();
            }
        });
    }

    public static void registerEntityRenderers() {
        EntityRenderRegistry.registerEntityRender(Entities.CHAIR, ChairEntityRenderer::new);
        PaladinFurnitureMod.pfmModCompatibilities.forEach(pfmModCompatibility -> {
            if (pfmModCompatibility.getClientModCompatiblity().isPresent()) {
                pfmModCompatibility.getClientModCompatiblity().get().registerEntityRenderer();
            }
        });
    }

    public static void registerModelLayers() {
        EntityRenderRegistry.registerModelLayer(EntityRenderIDs.MODEL_CUBE_LAYER, ModelEmpty.getTexturedModelData());
        EntityRenderRegistry.registerModelLayer(EntityRenderIDs.BED_HEAD_LAYER, PFMBedBlockEntityRenderer.getHeadTexturedModelData());
        EntityRenderRegistry.registerModelLayer(EntityRenderIDs.BED_FOOT_LAYER, PFMBedBlockEntityRenderer.getFootTexturedModelData());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockEntityRender(BlockEntityType blockEntityType, BlockEntityRendererProvider blockEntityRendererFactory) {
        void var1_1;
        EntityRenderRegistryImpl.registerBlockEntityRender(blockEntityType, (BlockEntityRendererProvider)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerEntityRender(EntityType entityType, EntityRendererProvider entityRendererFactory) {
        void var1_1;
        EntityRenderRegistryImpl.registerEntityRender(entityType, (EntityRendererProvider)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerModelLayer(ModelLayerLocation entityType, LayerDefinition texturedModelData) {
        void var1_1;
        EntityRenderRegistryImpl.registerModelLayer(entityType, (LayerDefinition)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static BlockEntityRendererProvider getStoveBlockEntityRenderer() {
        return EntityRenderRegistryImpl.getStoveBlockEntityRenderer();
    }
}

