/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.client.forge;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.unlikepaladin.pfm.blocks.models.basicLamp.UnbakedBasicLampModel;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;

public class PFMItemRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final PFMItemRenderer INSTANCE = new PFMItemRenderer();
    static Map<WoodVariant, Map<String, BakedModel>> bakedModels = new LinkedHashMap<WoodVariant, Map<String, BakedModel>>();
    static List<String> modelParts = new ArrayList<String>();

    public PFMItemRenderer() {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
    }

    public BakedModel getLampPartFromVariant(WoodVariant variantBase, int index) {
        if (!bakedModels.isEmpty() && !modelParts.isEmpty()) {
            return bakedModels.get(variantBase).get(modelParts.get(index));
        }
        modelParts.clear();
        bakedModels.clear();
        modelParts.addAll(UnbakedBasicLampModel.MODEL_PARTS_BASE);
        modelParts.addAll(UnbakedBasicLampModel.STATIC_PARTS);
        for (WoodVariant woodVariant : WoodVariantRegistry.getVariants()) {
            bakedModels.put(woodVariant, new LinkedHashMap());
            for (String part : modelParts) {
                bakedModels.get(woodVariant).put(part, Minecraft.m_91087_().m_91304_().getModel(new ResourceLocation("pfm", part.replaceAll("template", woodVariant.m_7912_()))));
            }
        }
        return bakedModels.get(variantBase).get(modelParts.get(index));
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        if (stack.m_150930_(PaladinFurnitureModBlocksItems.BASIC_LAMP_ITEM)) {
            WoodVariant variant = WoodVariantRegistry.OAK;
            if (stack.m_41782_()) {
                variant = WoodVariantRegistry.getVariant(ResourceLocation.m_135820_((String)stack.m_41737_("BlockEntityTag").m_128461_("variant")));
            }
            boolean glint = stack.m_41790_();
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            boolean leftHanded = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_5737_() == HumanoidArm.LEFT && mode.m_111841_();
            VertexConsumer consumer = ItemRenderer.m_115211_((MultiBufferSource)vertexConsumers, (RenderType)ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)true), (boolean)true, (boolean)glint);
            matrices.m_85849_();
            BakedModel lampShadeModel = ForgeHooksClient.handleCameraTransforms((PoseStack)matrices, (BakedModel)this.getLampPartFromVariant(variant, 4), (ItemTransforms.TransformType)mode, (boolean)leftHanded);
            matrices.m_85837_(-0.5, -0.5, -0.5);
            renderer.m_115189_(lampShadeModel, stack, light, overlay, matrices, consumer);
            BakedModel poleModel = this.getLampPartFromVariant(variant, 2);
            renderer.m_115189_(poleModel, stack, light, overlay, matrices, consumer);
            BakedModel bulbModel = this.getLampPartFromVariant(variant, 5);
            renderer.m_115189_(bulbModel, stack, light, overlay, matrices, consumer);
            matrices.m_85836_();
        }
    }
}

