/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.cookingforblockheads.forge;

import com.unlikepaladin.pfm.blocks.StoveBlock;
import com.unlikepaladin.pfm.compat.cookingforblockheads.forge.menu.StoveScreenHandlerBalm;
import com.unlikepaladin.pfm.registry.BlockEntities;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.entity.BalmBlockEntity;
import net.blay09.mods.balm.api.container.BalmContainerProvider;
import net.blay09.mods.balm.api.container.CombinedContainer;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.container.DefaultContainer;
import net.blay09.mods.balm.api.container.SubContainer;
import net.blay09.mods.balm.api.energy.BalmEnergyStorageProvider;
import net.blay09.mods.balm.api.energy.EnergyStorage;
import net.blay09.mods.balm.api.menu.BalmMenuProvider;
import net.blay09.mods.balm.api.provider.BalmProvider;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.api.capability.DefaultKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenItemProvider;
import net.blay09.mods.cookingforblockheads.api.capability.IKitchenSmeltingProvider;
import net.blay09.mods.cookingforblockheads.api.event.OvenCookedEvent;
import net.blay09.mods.cookingforblockheads.block.OvenBlock;
import net.blay09.mods.cookingforblockheads.compat.Compat;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.tile.IMutableNameable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class StoveBlockEntityBalm
extends BalmBlockEntity
implements IKitchenSmeltingProvider,
BalmMenuProvider,
IMutableNameable,
BalmContainerProvider,
BalmEnergyStorageProvider {
    private static final int COOK_TIME = 200;
    private final DefaultContainer container = new DefaultContainer(20){

        public boolean m_7013_(int slot, ItemStack itemStack) {
            if (slot < 3) {
                return !StoveBlockEntityBalm.this.getSmeltingResult(itemStack).m_41619_();
            }
            return slot != 3 || StoveBlockEntityBalm.isItemFuel(itemStack);
        }

        public void slotChanged(int slot) {
            if (slot >= 7 && slot < 16) {
                StoveBlockEntityBalm.this.slotCookTime[slot - 7] = 0;
            }
            StoveBlockEntityBalm.this.isDirty = true;
            StoveBlockEntityBalm.this.m_6596_();
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int id) {
            if (id == 0) {
                return StoveBlockEntityBalm.this.furnaceBurnTime;
            }
            if (id == 1) {
                return StoveBlockEntityBalm.this.currentItemBurnTime;
            }
            return id >= 2 && id <= 11 ? StoveBlockEntityBalm.this.slotCookTime[id - 2] : 0;
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                StoveBlockEntityBalm.this.furnaceBurnTime = value;
            } else if (id == 1) {
                StoveBlockEntityBalm.this.currentItemBurnTime = value;
            } else if (id >= 2 && id <= 11) {
                StoveBlockEntityBalm.this.slotCookTime[id - 2] = value;
            }
        }

        public int m_6499_() {
            return 11;
        }
    };
    private final EnergyStorage energyStorage = new EnergyStorage(10000){

        public int fill(int maxReceive, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.m_6596_();
            }
            return super.fill(maxReceive, simulate);
        }

        public int drain(int maxExtract, boolean simulate) {
            if (!simulate) {
                StoveBlockEntityBalm.this.m_6596_();
            }
            return super.drain(maxExtract, simulate);
        }
    };
    private final SubContainer inputContainer = new SubContainer((Container)this.container, 0, 3);
    private final SubContainer fuelContainer = new SubContainer((Container)this.container, 3, 4);
    private final SubContainer outputContainer = new SubContainer((Container)this.container, 4, 7);
    private final SubContainer processingContainer = new SubContainer((Container)this.container, 7, 16);
    private final SubContainer toolsContainer = new SubContainer((Container)this.container, 16, 20);
    private final DefaultKitchenItemProvider itemProvider = new DefaultKitchenItemProvider((Container)new CombinedContainer(new Container[]{this.toolsContainer, this.outputContainer}));
    private Component customName;
    private boolean isFirstTick = true;
    public int[] slotCookTime = new int[9];
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    private boolean isDirty;
    private boolean hasPowerUpgrade;
    private Direction facing;
    private final Container singleSlotRecipeWrapper = new DefaultContainer(1);

    public StoveBlockEntityBalm(BlockPos pos, BlockState state) {
        super(BlockEntities.STOVE_BLOCK_ENTITY, pos, state);
    }

    public boolean m_7531_(int id, int type) {
        return super.m_7531_(id, type);
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.clientTick(level, pos, state);
        }
    }

    public void clientTick(Level level, BlockPos pos, BlockState state) {
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        if (blockEntity instanceof StoveBlockEntityBalm) {
            StoveBlockEntityBalm stoveBlockEntityBalm = (StoveBlockEntityBalm)blockEntity;
            stoveBlockEntityBalm.serverTick(level, pos, state);
        }
    }

    public void serverTick(Level level, BlockPos pos, BlockState state) {
        if (this.isFirstTick && state.m_60734_() instanceof StoveBlock) {
            this.facing = (Direction)state.m_61143_((Property)StoveBlock.f_48683_);
            this.isFirstTick = false;
        }
        if (this.isDirty) {
            this.sync();
            this.isDirty = false;
        }
        boolean hasChanged = false;
        int burnPotential = 200 - this.furnaceBurnTime;
        if (this.hasPowerUpgrade && burnPotential > 0 && this.shouldConsumeFuel()) {
            this.furnaceBurnTime += this.energyStorage.drain(burnPotential, false);
        }
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!level.f_46443_) {
            ItemStack itemStack;
            int i;
            ItemStack containerItem;
            int firstEmptySlot;
            if (this.furnaceBurnTime == 0 && this.shouldConsumeFuel()) {
                for (firstEmptySlot = 0; firstEmptySlot < this.fuelContainer.m_6643_(); ++firstEmptySlot) {
                    ItemStack fuelItem = this.fuelContainer.m_8020_(firstEmptySlot);
                    if (fuelItem.m_41619_()) continue;
                    this.currentItemBurnTime = this.furnaceBurnTime = (int)Math.max(1.0, (double)StoveBlockEntityBalm.getBurnTime(fuelItem) * CookingForBlockheadsConfig.getActive().ovenFuelTimeMultiplier);
                    if (this.furnaceBurnTime == 0) break;
                    containerItem = Balm.getHooks().getCraftingRemainingItem(fuelItem);
                    fuelItem.m_41774_(1);
                    if (fuelItem.m_41619_()) {
                        this.fuelContainer.m_6836_(firstEmptySlot, containerItem);
                    }
                    hasChanged = true;
                    break;
                }
            }
            firstEmptySlot = -1;
            int firstTransferSlot = -1;
            for (i = 0; i < this.processingContainer.m_6643_(); ++i) {
                itemStack = this.processingContainer.m_8020_(i);
                if (!itemStack.m_41619_()) {
                    if (this.slotCookTime[i] != -1) {
                        ItemStack smeltingResult;
                        double maxCookTime = 200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier;
                        if ((double)this.slotCookTime[i] >= maxCookTime && firstTransferSlot == -1) {
                            firstTransferSlot = i;
                            continue;
                        }
                        if (this.furnaceBurnTime > 0) {
                            int n = i;
                            this.slotCookTime[n] = this.slotCookTime[n] + 1;
                        }
                        if (!((double)this.slotCookTime[i] >= maxCookTime) || (smeltingResult = this.getSmeltingResult(itemStack)).m_41619_()) continue;
                        ItemStack resultStack = smeltingResult.m_41777_();
                        this.processingContainer.m_6836_(i, resultStack);
                        Balm.getEvents().fireEvent((Object)new OvenCookedEvent(level, this.f_58858_, resultStack));
                        this.slotCookTime[i] = -1;
                        if (firstTransferSlot != -1) continue;
                        firstTransferSlot = i;
                        continue;
                    }
                    if (firstTransferSlot != -1) continue;
                    firstTransferSlot = i;
                    continue;
                }
                if (firstEmptySlot != -1) continue;
                firstEmptySlot = i;
            }
            if (firstTransferSlot != -1) {
                containerItem = this.processingContainer.m_8020_(firstTransferSlot);
                containerItem = ContainerUtils.insertItemStacked((Container)this.outputContainer, (ItemStack)containerItem, (boolean)false);
                this.processingContainer.m_6836_(firstTransferSlot, containerItem);
                if (containerItem.m_41619_()) {
                    this.slotCookTime[firstTransferSlot] = 0;
                }
                hasChanged = true;
            }
            if (firstEmptySlot != -1) {
                for (i = 0; i < this.inputContainer.m_6643_(); ++i) {
                    itemStack = this.inputContainer.m_8020_(i);
                    if (itemStack.m_41619_()) continue;
                    this.processingContainer.m_6836_(firstEmptySlot, itemStack.m_41620_(1));
                    if (itemStack.m_41613_() > 0) break;
                    this.inputContainer.m_6836_(i, ItemStack.f_41583_);
                    break;
                }
            }
        }
        if (hasChanged) {
            this.m_6596_();
        }
    }

    public ItemStack getSmeltingResult(ItemStack itemStack) {
        ItemStack result = CookingRegistry.getSmeltingResult((ItemStack)itemStack);
        if (!result.m_41619_()) {
            return result;
        }
        this.singleSlotRecipeWrapper.m_6836_(0, itemStack);
        Recipe recipe = this.f_58857_.m_7465_().m_44015_(RecipeType.f_44108_, this.singleSlotRecipeWrapper, this.f_58857_).orElse(null);
        if (recipe != null && !(result = recipe.m_8043_()).m_41619_() && result.m_41720_().m_41472_()) {
            return result;
        }
        return !result.m_41619_() && CookingRegistry.isNonFoodRecipe((ItemStack)result) ? result : ItemStack.f_41583_;
    }

    public static boolean isItemFuel(ItemStack itemStack) {
        if (CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil) {
            return itemStack.m_204117_(Compat.getCookingOilTag());
        }
        return StoveBlockEntityBalm.getBurnTime(itemStack) > 0;
    }

    protected static int getBurnTime(ItemStack itemStack) {
        if (itemStack.m_41619_()) {
            return 0;
        }
        return CookingForBlockheadsConfig.getActive().ovenRequiresCookingOil && itemStack.m_204117_(Compat.getCookingOilTag()) ? 800 : Balm.getHooks().getBurnTime(itemStack);
    }

    private boolean shouldConsumeFuel() {
        for (int i = 0; i < this.processingContainer.m_6643_(); ++i) {
            ItemStack cookingStack = this.processingContainer.m_8020_(i);
            if (cookingStack.m_41619_() || this.slotCookTime[i] == -1) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.container.deserialize(tagCompound.m_128469_("ItemHandler"));
        this.furnaceBurnTime = tagCompound.m_128448_("BurnTime");
        this.currentItemBurnTime = tagCompound.m_128448_("CurrentItemBurnTime");
        this.slotCookTime = tagCompound.m_128465_("CookTimes");
        if (this.slotCookTime.length != 9) {
            this.slotCookTime = new int[9];
        }
        this.hasPowerUpgrade = tagCompound.m_128471_("HasPowerUpgrade");
        this.energyStorage.setEnergy(tagCompound.m_128451_("EnergyStored"));
        if (tagCompound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)tagCompound.m_128461_("CustomName"));
        }
    }

    public void m_183515_(CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128365_("ItemHandler", (Tag)this.container.serialize());
        tagCompound.m_128376_("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.m_128376_("CurrentItemBurnTime", (short)this.currentItemBurnTime);
        tagCompound.m_128385_("CookTimes", ArrayUtils.clone((int[])this.slotCookTime));
        tagCompound.m_128379_("HasPowerUpgrade", this.hasPowerUpgrade);
        tagCompound.m_128405_("EnergyStored", this.energyStorage.getEnergy());
        if (this.customName != null) {
            tagCompound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
    }

    public void writeUpdateTag(CompoundTag tag) {
        this.m_183515_(tag);
    }

    public boolean hasPowerUpgrade() {
        return this.hasPowerUpgrade;
    }

    public void setHasPowerUpgrade(boolean hasPowerUpgrade) {
        this.hasPowerUpgrade = hasPowerUpgrade;
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)OvenBlock.POWERED, (Comparable)Boolean.valueOf(hasPowerUpgrade)));
        this.m_6596_();
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public float getBurnTimeProgress() {
        return this.currentItemBurnTime == 0 && this.furnaceBurnTime > 0 ? 1.0f : (float)this.furnaceBurnTime / (float)this.currentItemBurnTime;
    }

    public float getCookProgress(int i) {
        return (float)this.slotCookTime[i] / (float)(200.0 * CookingForBlockheadsConfig.getActive().ovenCookTimeMultiplier);
    }

    public ItemStack smeltItem(ItemStack itemStack) {
        return ContainerUtils.insertItemStacked((Container)this.inputContainer, (ItemStack)itemStack, (boolean)false);
    }

    public ItemStack getToolItem(int i) {
        return this.toolsContainer.m_8020_(i);
    }

    public void setToolItem(int i, ItemStack itemStack) {
        this.toolsContainer.m_6836_(i, itemStack);
    }

    public Container getContainer(Direction side) {
        if (side == null) {
            return this.getContainer();
        }
        return switch (side) {
            case Direction.UP -> this.inputContainer;
            case Direction.DOWN -> this.outputContainer;
            default -> this.fuelContainer;
        };
    }

    public List<BalmProvider<?>> getProviders() {
        return List.of(new BalmProvider(IKitchenItemProvider.class, (Object)this.itemProvider), new BalmProvider(IKitchenSmeltingProvider.class, (Object)this));
    }

    public Container getInputContainer() {
        return this.inputContainer;
    }

    public Container getFuelContainer() {
        return this.fuelContainer;
    }

    public Direction getFacing() {
        return this.facing == null ? Direction.NORTH : this.facing;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new StoveScreenHandlerBalm(i, playerInventory, this);
    }

    public AABB balmGetRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, 0, -1), this.f_58858_.m_7918_(2, 1, 2));
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public void setCustomName(Component customName) {
        this.customName = customName;
        this.m_6596_();
    }

    public boolean m_8077_() {
        return this.customName != null;
    }

    @Nullable
    public Component m_7770_() {
        return this.customName;
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)"container.cookingforblockheads.oven");
    }

    public Container getContainer() {
        return this.container;
    }

    public ContainerData getContainerData() {
        return this.dataAccess;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128365_("ItemHandler", (Tag)this.container.serialize());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        super.handleUpdateTag(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.container.deserialize(pkt.m_131708_().m_128469_("ItemHandler"));
    }

    protected void onContainerOpen(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.f_12012_);
            this.setOpen(state, true);
        }
    }

    protected void onContainerClose(Level world, BlockPos pos, BlockState state) {
        if (state.m_60734_() instanceof StoveBlock) {
            this.playSound(state, SoundEvents.f_12011_);
            this.setOpen(state, false);
        }
    }

    void setOpen(BlockState state, boolean open) {
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)state.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3);
    }

    public void onClose(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.onContainerClose(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void onOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.onContainerOpen(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }
}

