/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.compat.rei;

import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class FurnitureDisplay
implements Display {
    protected FurnitureRecipe recipe;
    public static final CategoryIdentifier<FurnitureDisplay> IDENTIFIER = CategoryIdentifier.of((ResourceLocation)new ResourceLocation("pfm", "furniture"));
    public List<EntryIngredient> input;
    public List<EntryIngredient> output;

    public FurnitureDisplay(FurnitureRecipe recipe) {
        this.recipe = recipe;
        this.output = Collections.singletonList(EntryIngredients.of((ItemStack)recipe.m_8043_()));
    }

    public List<EntryIngredient> getInputEntries() {
        NonNullList<Ingredient> ingredients = this.recipe.m_7527_();
        HashMap<Item, Integer> containedItems = new HashMap<Item, Integer>();
        for (Ingredient ingredient : ingredients) {
            for (ItemStack stack : ingredient.m_43908_()) {
                if (!containedItems.containsKey(stack.m_41720_())) {
                    containedItems.put(stack.m_41720_(), 1);
                    continue;
                }
                containedItems.put(stack.m_41720_(), (Integer)containedItems.get(stack.m_41720_()) + 1);
            }
        }
        ArrayList<Ingredient> finalList = new ArrayList<Ingredient>();
        for (Map.Entry entry : containedItems.entrySet()) {
            finalList.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())}));
        }
        finalList.sort(Comparator.comparing(o -> o.m_43908_()[0].m_41720_().toString()));
        return EntryIngredients.ofIngredients(finalList);
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return IDENTIFIER;
    }
}

