/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.registry.PaladinFurnitureModBlocksItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ExtraStoolVariant
extends VariantBase<ExtraStoolVariant> {
    public static ExtraStoolVariant GRAY_DARK_OAK = new ExtraStoolVariant(Blocks.f_50497_, Blocks.f_50009_, "gray_dark_oak");
    public static ExtraStoolVariant WHITE = new ExtraStoolVariant(Blocks.f_50542_, Blocks.f_50498_, "white");
    public static ExtraStoolVariant GRAY = new ExtraStoolVariant(null, Blocks.f_50498_, "gray");
    public static ExtraStoolVariant LIGHT_GRAY_DARK_OAK = new ExtraStoolVariant(Blocks.f_50498_, Blocks.f_50009_, "light_gray_dark_oak");
    private final String name;
    private final Block baseBlock;
    private final Block secondaryBlock;
    static final List<ExtraStoolVariant> DEFAULT_VARIANTS = new ArrayList<ExtraStoolVariant>();

    public static List<ExtraStoolVariant> values() {
        if (DEFAULT_VARIANTS.isEmpty()) {
            DEFAULT_VARIANTS.add(GRAY_DARK_OAK);
            DEFAULT_VARIANTS.add(WHITE);
            DEFAULT_VARIANTS.add(GRAY);
            DEFAULT_VARIANTS.add(LIGHT_GRAY_DARK_OAK);
        }
        return DEFAULT_VARIANTS;
    }

    ExtraStoolVariant(ResourceLocation identifier, Block baseBlock, Block secondaryBlock) {
        super(identifier);
        this.name = identifier.m_135815_();
        this.baseBlock = baseBlock;
        this.secondaryBlock = secondaryBlock;
    }

    ExtraStoolVariant(Block baseBlock, Block secondaryBlock, String name) {
        this(new ResourceLocation("", name), baseBlock, secondaryBlock);
    }

    public String m_7912_() {
        return this.name;
    }

    @Override
    public Block getBaseBlock() {
        if (this.baseBlock == null) {
            return PaladinFurnitureModBlocksItems.RAW_CONCRETE;
        }
        return this.baseBlock;
    }

    @Override
    public Block getSecondaryBlock() {
        return this.secondaryBlock;
    }

    @Override
    public boolean isNetherWood() {
        return false;
    }

    @Override
    public Material getVanillaMaterial() {
        return this.getBaseBlock().m_49966_().m_60767_();
    }

    @Override
    public ExtraStoolVariant getVariantType() {
        return this;
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.m_135827_().equals("") || this.identifier.m_135827_().equals("minecraft");
    }

    @Override
    public void initializeChildrenBlocks() {
    }

    @Override
    public void initializeChildrenItems() {
    }

    @Override
    public Block mainChild() {
        return this.getBaseBlock();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture(BlockType type) {
        if (type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.getSecondaryBlock());
        }
        return ModelHelper.getTextureId(this.getBaseBlock());
    }

    @Override
    public String getPath() {
        return this.identifier.m_135815_();
    }
}

