/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.unlikepaladin.pfm.runtime.PFMResourceProgress;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.Logger;

public abstract class PFMGenerator
implements PFMResourceProgress {
    protected final Path output;
    private final boolean logOrDebug;
    private final Logger logger;
    public static final HashFunction SHA1 = Hashing.sha1();
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static boolean assetsRunning = false;
    private static boolean dataRunning = false;

    protected PFMGenerator(Path output, boolean logOrDebug, Logger logger) {
        this.output = output;
        this.logOrDebug = logOrDebug;
        this.logger = logger;
    }

    protected void createPackIcon() {
        File file = new File(this.output.toFile(), "pack.png");
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(PFMRuntimeResources.getImageData()));
            ImageIO.write((RenderedImage)image, "png", file);
            image.flush();
        }
        catch (IOException e) {
            this.logger.warn("Failed to create resource icon {}", (Object)e.getMessage());
        }
    }

    public static boolean areAssetsRunning() {
        return assetsRunning;
    }

    public static boolean isDataRunning() {
        return dataRunning;
    }

    protected static void setAssetsRunning(boolean running) {
        assetsRunning = running;
    }

    protected static void setDataRunning(boolean running) {
        dataRunning = running;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Path getOutput() {
        return this.output;
    }

    public Path getOrCreateSubDirectory(String name) {
        return PFMRuntimeResources.createDirIfNeeded(this.output.resolve(name));
    }

    public abstract void run() throws IOException;

    public void log(String s, Object p0) {
        this.log(s, p0, "");
    }

    public void log(String s) {
        this.log(s, "", "");
    }

    public void log(String s, Object p0, Object p1) {
        if (this.logOrDebug) {
            this.logger.info(s, p0, p1);
        } else {
            this.logger.debug(s, p0, p1);
        }
    }

    public List<String> hashDirectory(File directory, boolean includeHiddenFiles) throws IOException {
        if (!directory.isDirectory()) {
            this.logger.error("Not a directory");
            throw new IllegalArgumentException("Not a directory");
        }
        Vector<String> fileStreams = new Vector<String>();
        this.collectFiles(directory, fileStreams, includeHiddenFiles);
        return fileStreams;
    }

    private void collectFiles(File directory, List<String> hashList, boolean includeHiddenFiles) throws IOException {
        File[] fileArray = directory.listFiles();
        if (fileArray != null) {
            ArrayList<File> files = new ArrayList<File>(Arrays.asList(fileArray));
            files.removeIf(file -> file.getName().contains("dataHash") || file.getName().contains("modsList"));
            files.sort(Comparator.comparing(File::getName));
            for (File file2 : files) {
                if (file2.getName().contains("dataHash") || file2.getName().contains("modsList") || file2 == null || !includeHiddenFiles && Files.isHidden(file2.toPath())) continue;
                if (file2.isDirectory()) {
                    this.collectFiles(file2, hashList, includeHiddenFiles);
                    continue;
                }
                FileInputStream stream = new FileInputStream(file2);
                try {
                    HashCode code = HashCode.fromBytes((byte[])stream.readAllBytes());
                    hashList.add(code.toString());
                }
                catch (Exception e) {
                    this.logger.warn("File {} was less than 1 byte or invalid, skipping, {}", (Object)file2.getName(), (Object)e);
                }
                stream.close();
            }
        }
    }

    public abstract void setProgress(String var1);
}

