/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.bracket;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.ResourceLocationBracketHandler;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.replacement.ITargetingStrategy;
import com.blamejared.crafttweaker.natives.block.ExpandBlockState;
import com.blamejared.crafttweaker.natives.block.material.ExpandMaterial;
import com.blamejared.crafttweaker.natives.world.damage.ExpandDamageSource;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.bracket.BracketHandlers")
@Document(value="vanilla/api/BracketHandlers")
public class BracketHandlers {
    @ZenCodeType.Method
    @BracketResolver(value="attribute")
    public static Attribute getAttribute(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Attribute BEP <attribute:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Syntax is <attribute:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return (Attribute)Registry.f_122866_.m_6612_(key).orElseThrow(() -> new IllegalArgumentException("Could not get attribute with name: <attribute:" + tokens + ">! Attribute does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="block")
    public static Block getBlock(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Block BEP <block:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Syntax is <block:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return (Block)Registry.f_122824_.m_6612_(key).orElseThrow(() -> new IllegalArgumentException("Could not get block with name: <block:" + tokens + ">! Block does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="material")
    public static Material getMaterial(String tokens) {
        return ExpandMaterial.getOptionalMaterial(tokens).orElseThrow(() -> new IllegalArgumentException("Could not find material <material:" + tokens + ">!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="blockstate")
    public static BlockState getBlockState(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("BlockState BEP <blockstate:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":", 4)).length > 1) {
            String blockName = split[0] + ":" + split[1];
            String properties = split.length > 2 ? split[2] : "";
            Optional found = Registry.f_122824_.m_6612_(new ResourceLocation(blockName));
            if (found.isEmpty()) {
                CraftTweakerAPI.LOGGER.error("Error creating BlockState!", (Throwable)new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">! The block does not appear to exist!"));
            } else {
                return BracketHandlers.getBlockState((Block)found.get(), blockName, properties);
            }
        }
        CraftTweakerAPI.LOGGER.error("Error creating BlockState!", (Throwable)new IllegalArgumentException("Could not get BlockState from: <blockstate:" + tokens + ">!"));
        return null;
    }

    public static BlockState getBlockState(String name, String properties) {
        return BracketHandlers.getBlockState((Block)Registry.f_122824_.m_7745_(new ResourceLocation(name)), name, properties);
    }

    public static BlockState getBlockState(Block block, String name, String properties) {
        BlockState blockState = block.m_49966_();
        if (properties != null && !properties.isEmpty()) {
            for (String propertyPair : properties.split(",")) {
                String[] splitPair = propertyPair.split("=");
                if (splitPair.length != 2) {
                    CraftTweakerAPI.LOGGER.warn("Invalid blockstate property format '{}'. Using default property value.", (Object)propertyPair);
                    continue;
                }
                blockState = ExpandBlockState.withProperty(blockState, splitPair[0], splitPair[1]);
            }
        }
        return blockState;
    }

    @BracketResolver(value="mobeffect")
    @ZenCodeType.Method
    public static MobEffect getMobEffect(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("MobEffect BEP <mobeffect:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get effect with name: <mobeffect:" + tokens + ">! Syntax is <effect:modid:mobeffect>");
        }
        return (MobEffect)Registry.f_122823_.m_6612_(new ResourceLocation(split[0], split[1])).orElseThrow(() -> new IllegalArgumentException("Could not get effect with name: <mobeffect:" + tokens + ">! Effect does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="enchantment")
    public static Enchantment getEnchantment(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Enchantment BEP <enchantment:{}> does not seem to be lower-case!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': not a valid bracket handler, syntax is <enchantment:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        Optional found = Registry.f_122825_.m_6612_(key);
        if (found.isEmpty()) {
            throw new IllegalArgumentException("Could not get enchantment '" + tokens + "': the enchantment does not appear to exist");
        }
        return (Enchantment)found.get();
    }

    @ZenCodeType.Method
    @BracketResolver(value="entitytype")
    public static EntityType getEntityType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        return (EntityType)Registry.f_122826_.m_6612_(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get entitytype <entitytype:" + tokens + ">"));
    }

    @BracketResolver(value="item")
    @ZenCodeType.Method
    public static IItemStack getItem(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Item BEP <item:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Syntax is <item:modid:itemname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        ItemStack stack = Registry.f_122827_.m_6612_(key).map(ItemStack::new).orElseThrow(() -> new IllegalArgumentException("Could not get item with name: <item:" + tokens + ">! Item does not appear to exist!"));
        return IItemStack.of(stack);
    }

    @BracketResolver(value="potion")
    @ZenCodeType.Method
    public static Potion getPotion(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Potion BEP <potion:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Syntax is <potion:modid:potionname>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return (Potion)Registry.f_122828_.m_6612_(key).orElseThrow(() -> new IllegalArgumentException("Could not get potion with name: <potion:" + tokens + ">! Potion does not appear to exist!"));
    }

    @ZenCodeType.Method
    public static IRecipeManager<?> getRecipeManager(String tokens) {
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("RecipeType BEP <recipetype:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if (tokens.equalsIgnoreCase("crafttweaker:scripts")) {
            throw new IllegalArgumentException("Nice try, but there's no reason you need to access the <recipetype:crafttweaker:scripts> recipe manager!");
        }
        ResourceLocation key = new ResourceLocation(tokens);
        IRecipeManager<Recipe<?>> result = RecipeTypeBracketHandler.getOrDefault(key);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not get RecipeType with name: <recipetype:" + tokens + ">! RecipeType does not appear to exist!");
    }

    @Deprecated(forRemoval=true)
    @ZenCodeType.Method
    public static ResourceLocation getResourceLocation(String tokens) {
        return ResourceLocationBracketHandler.getResourceLocation(tokens);
    }

    @ZenCodeType.Method
    @BracketResolver(value="profession")
    public static VillagerProfession getProfession(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get profession <profession:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        return (VillagerProfession)Registry.f_122869_.m_6612_(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get profession with name: <profession:" + tokens + ">! Profession does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="damagesource")
    public static DamageSource getDamageSource(String tokens) {
        return ExpandDamageSource.PRE_REGISTERED_DAMAGE_SOURCES.getOrDefault(tokens, new DamageSource(tokens));
    }

    @ZenCodeType.Method
    @BracketResolver(value="creativemodetab")
    public static CreativeModeTab getCreativeModeTab(String tokens) {
        return Arrays.stream(CreativeModeTab.f_40748_).filter(g -> g.m_40783_().equals(tokens)).findAny().orElseThrow(() -> new IllegalArgumentException("Could not find creativemodetab for '<creativemodetab:" + tokens + ">'!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="soundevent")
    public static SoundEvent getSoundEvent(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get sound event <soundevent:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        return (SoundEvent)Registry.f_122821_.m_6612_(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get sound event with name: <soundevent:" + tokens + ">! Sound event does not appear to exist!"));
    }

    @ZenCodeType.Method
    @BracketResolver(value="targetingstrategy")
    public static ITargetingStrategy getTargetingStrategy(String tokens) {
        String[] split;
        if (!tokens.toLowerCase(Locale.ENGLISH).equals(tokens)) {
            CraftTweakerAPI.LOGGER.warn("Targeting strategy BEP <targetingstrategy:{}> does not seem to be lower-cased!", (Object)tokens);
        }
        if ((split = tokens.split(":")).length != 2) {
            throw new IllegalArgumentException("Could not get targeting strategy with <targetingstrategy:" + tokens + ">: syntax is <targetingstrategy:modid:name>");
        }
        ResourceLocation key = new ResourceLocation(split[0], split[1]);
        return ITargetingStrategy.find(key);
    }

    @ZenCodeType.Method
    @BracketResolver(value="villagertype")
    public static VillagerType getVillagerType(String tokens) {
        int length = tokens.split(":").length;
        if (length == 0 || length > 2) {
            throw new IllegalArgumentException("Could not get profession <villagertype:" + tokens + ">");
        }
        ResourceLocation resourceLocation = new ResourceLocation(tokens);
        return (VillagerType)Registry.f_122868_.m_6612_(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Could not get villagertype with name: <villagertype:" + tokens + ">! Villager Type does not appear to exist!"));
    }
}

