/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.game;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.custom.RecipeTypeBracketHandler;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.game.Game")
@Document(value="vanilla/api/game/Game")
public class Game {
    @ZenCodeGlobals.Global(value="game")
    public static final Game INSTANCE = new Game();

    private Game() {
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="effects")
    public Collection<MobEffect> getMobEffects() {
        return Registry.f_122823_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    public Collection<Enchantment> getEnchantments() {
        return Registry.f_122825_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="entityTypes")
    public Collection<EntityType> getEntityTypes() {
        return Registry.f_122826_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fluids")
    public Collection<Fluid> getFluids() {
        return Registry.f_122822_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="items")
    public Collection<IItemStack> getItemStacks() {
        return Registry.f_122827_.m_123024_().map(Item::m_7968_).filter(Predicate.not(ItemStack::m_41619_)).map(IItemStack::of).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potions")
    public Collection<Potion> getPotions() {
        return Registry.f_122828_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="recipeTypes")
    public Collection<IRecipeManager> getRecipeTypes() {
        return Registry.f_122864_.m_123024_().map(RecipeTypeBracketHandler::getOrDefault).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocks")
    public Collection<Block> getBlocks() {
        return Registry.f_122824_.m_123024_().toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blockStates")
    public Collection<BlockState> getBlockStates() {
        return Registry.f_122824_.m_123024_().flatMap(block -> block.m_49965_().m_61056_().stream()).collect(Collectors.toList());
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="villagerProfessions")
    public Collection<VillagerProfession> getVillagerProfessions() {
        return Registry.f_122869_.m_123024_().toList();
    }

    @ZenCodeType.Method
    public String localize(String translationKey) {
        return Language.m_128107_().m_6834_(translationKey);
    }
}

