/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.mod;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.mod.Mod")
@Document(value="vanilla/api/mod/Mod")
public final class Mod {
    private final String id;
    private final String displayName;
    private final String version;

    public Mod(String id, String displayName, String version) {
        this.id = id;
        this.displayName = displayName;
        this.version = version;
    }

    private <T> Collection<T> getRegistryObjects(Registry<T> registry) {
        return registry.m_6566_().stream().filter(resourceLocation -> resourceLocation.m_135827_().equals(this.id())).map(resourceLocation -> registry.m_6612_(resourceLocation).orElseThrow(() -> new IllegalArgumentException("Cannot get registry object from name: '" + resourceLocation + "'! This should never happen!"))).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="items")
    public Collection<Item> getItems() {
        return this.getRegistryObjects((Registry)Registry.f_122827_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="itemStacks")
    public Collection<IItemStack> getItemStacks() {
        return this.getItems().stream().map(Item::m_7968_).map(IItemStack::of).toList();
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="potions")
    public Collection<Potion> getPotions() {
        return this.getRegistryObjects((Registry)Registry.f_122828_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="attributes")
    public Collection<Attribute> getAttributes() {
        return this.getRegistryObjects(Registry.f_122866_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="fluids")
    public Collection<Fluid> getFluids() {
        return this.getRegistryObjects((Registry)Registry.f_122822_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="enchantments")
    public Collection<Enchantment> getEnchantments() {
        return this.getRegistryObjects(Registry.f_122825_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="blocks")
    public Collection<Block> getBlocks() {
        return this.getRegistryObjects((Registry)Registry.f_122824_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="mobEffects")
    public Collection<MobEffect> getMobEffects() {
        return this.getRegistryObjects(Registry.f_122823_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="villagerProfessions")
    public Collection<VillagerProfession> getVillagerProfessions() {
        return this.getRegistryObjects((Registry)Registry.f_122869_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="soundEvents")
    public Collection<SoundEvent> getSoundEvents() {
        return this.getRegistryObjects(Registry.f_122821_);
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="id")
    public String id() {
        return this.id;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="displayName")
    public String displayName() {
        return this.displayName;
    }

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="version")
    public String version() {
        return this.version;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Mod that = (Mod)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.displayName, this.version);
    }

    public String toString() {
        return "Mod[id=" + this.id + ", displayName=" + this.displayName + ", version=" + this.version + "]";
    }
}

