/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction1D;
import com.blamejared.crafttweaker.platform.Services;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CTShapelessRecipeBase
implements CraftingRecipe {
    private final IIngredient[] ingredients;
    private final IItemStack output;
    @Nullable
    private final RecipeFunction1D function;
    private final ResourceLocation resourceLocation;

    public CTShapelessRecipeBase(String name, IItemStack output, IIngredient[] ingredients, @Nullable RecipeFunction1D function) {
        this.resourceLocation = CraftTweakerConstants.rl(name);
        this.output = output;
        this.function = function;
        boolean containsNull = false;
        for (IIngredient ingredient : ingredients) {
            if (ingredient != null && !ingredient.asVanillaIngredient().m_43947_()) continue;
            CraftTweakerAPI.LOGGER.warn("Shapeless recipe with ID '{}' contains null or empty ingredients, removing entries!", (Object)this.resourceLocation);
            containsNull = true;
            break;
        }
        if (containsNull) {
            ingredients = (IIngredient[])Arrays.stream(ingredients).filter(Objects::nonNull).filter(iIngredient -> !iIngredient.asVanillaIngredient().m_43947_()).toArray(IIngredient[]::new);
        }
        this.ingredients = ingredients;
    }

    public boolean matches(CraftingContainer inv, Level worldIn) {
        boolean[] visited = this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {});
        int visitedCount = 0;
        for (int slot = 0; slot < visited.length; ++slot) {
            if (visited[slot]) {
                ++visitedCount;
                continue;
            }
            if (inv.m_8020_(slot).m_41619_()) continue;
            return false;
        }
        return visitedCount == this.ingredients.length;
    }

    public ItemStack assemble(CraftingContainer inv) {
        if (this.function == null) {
            return this.output.getInternal().m_41777_();
        }
        IItemStack[] stacks = new IItemStack[this.ingredients.length];
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> {
            stacks[ingredientIndex] = stack.setAmount(1);
        });
        return this.function.process(this.output, stacks).getImmutableInternal();
    }

    @Nullable
    public RecipeFunction1D getFunction() {
        return this.function;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= this.ingredients.length;
    }

    public ItemStack m_8043_() {
        return this.output.getInternal().m_41777_();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        this.forAllUniqueMatches((Container)inv, (ingredientIndex, matchingSlot, stack) -> remainingItems.set(matchingSlot, (Object)this.ingredients[ingredientIndex].getRemainingItem(stack).getInternal()));
        return remainingItems;
    }

    private boolean[] forAllUniqueMatches(Container inv, ForAllUniqueAction action) {
        boolean[] visited = new boolean[inv.m_6643_()];
        block0: for (int ingredientIndex = 0; ingredientIndex < this.ingredients.length; ++ingredientIndex) {
            IIngredient ingredient = this.ingredients[ingredientIndex];
            for (int i = 0; i < inv.m_6643_(); ++i) {
                IItemStack stack;
                ItemStack stackInSlot;
                if (visited[i] || (stackInSlot = inv.m_8020_(i)).m_41619_() || !ingredient.matches(stack = IItemStack.of(stackInSlot))) continue;
                visited[i] = true;
                action.accept(ingredientIndex, i, stack);
                continue block0;
            }
        }
        return visited;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        for (IIngredient ingredient : this.ingredients) {
            ingredients.add((Object)ingredient.asVanillaIngredient());
        }
        return ingredients;
    }

    public String m_6076_() {
        return super.m_6076_();
    }

    public ResourceLocation m_6423_() {
        return this.resourceLocation;
    }

    public RecipeSerializer<CTShapelessRecipeBase> m_7707_() {
        return Services.REGISTRY.getCTShapelessRecipeSerializer();
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public IIngredient[] getCtIngredients() {
        return this.ingredients;
    }

    public IItemStack getCtOutput() {
        return this.output;
    }

    private static interface ForAllUniqueAction {
        public void accept(int var1, int var2, IItemStack var3);
    }
}

