/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.command.type;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.command.CommandUtilities;
import com.blamejared.crafttweaker.api.plugin.ICommandRegistrationHandler;
import com.blamejared.crafttweaker.api.tag.CraftTweakerTagRegistry;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.tag.type.KnownTag;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker.platform.helper.inventory.IInventoryWrapper;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class InventoryCommands {
    private InventoryCommands() {
    }

    public static void registerCommands(ICommandRegistrationHandler handler) {
        handler.registerRootCommand("inventory", Component.m_237115_((String)"crafttweaker.command.description.inventory"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((Player)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.m_41619_()).map(ItemStackUtil::getCommandString).collect(Collectors.joining("\n", "Inventory items\n", ""));
            CraftTweakerAPI.LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.inventory.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerSubCommand("inventory", "tags", Component.m_237115_((String)"crafttweaker.command.description.inventory.tags"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((Player)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.m_41619_()).map(it -> Pair.of((Object)ItemStackUtil.getCommandString(it), CraftTweakerTagRegistry.INSTANCE.knownTagManager(Registry.f_122904_).getTagsFor(it.m_41720_()))).map(it -> (String)it.getFirst() + "\n" + InventoryCommands.stringify((Collection)it.getSecond())).collect(Collectors.joining("\n", "Inventory item tags\n", ""));
            CraftTweakerAPI.LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.inventory.list.tag")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
        handler.registerSubCommand("inventory", "registryNames", Component.m_237115_((String)"crafttweaker.command.description.inventory.registryNames"), builder -> builder.executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            IInventoryWrapper inventory = Services.PLATFORM.getPlayerInventory((Player)player);
            String inventoryContents = IntStream.range(0, inventory.getContainerSize()).mapToObj(inventory::getItem).filter(it -> !it.m_41619_()).map(ItemStack::m_41720_).map(arg_0 -> ((DefaultedRegistry)Registry.f_122827_).m_7981_(arg_0)).map(ResourceLocation::toString).collect(Collectors.joining("\n", "Inventory items\n", ""));
            CraftTweakerAPI.LOGGER.info(inventoryContents);
            CommandUtilities.send(CommandUtilities.openingLogFile(Component.m_237110_((String)"crafttweaker.command.list.check.log", (Object[])new Object[]{CommandUtilities.makeNoticeable(Component.m_237115_((String)"crafttweaker.command.misc.inventory.list")), CommandUtilities.getFormattedLogFile()}).m_130940_(ChatFormatting.GREEN)), (Player)player);
            return 1;
        }));
    }

    private static String stringify(Collection<KnownTag<Item>> tags) {
        if (tags.isEmpty()) {
            return "- No tags";
        }
        return tags.stream().map(MCTag::getCommandString).map(it -> String.format("- %s", it)).collect(Collectors.joining("\n"));
    }
}

