/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.plugin.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.annotation.BracketDumper;
import com.blamejared.crafttweaker.api.annotation.BracketResolver;
import com.blamejared.crafttweaker.api.annotation.BracketValidator;
import com.blamejared.crafttweaker.api.plugin.IBracketParserRegistrationHandler;
import com.google.common.base.CaseFormat;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.openzen.zencode.java.ZenCodeType;

final class BracketParserRegistrationManager {
    private final Map<String, BracketData> data = new HashMap<String, BracketData>();

    BracketParserRegistrationManager() {
    }

    void addRegistrationCandidate(Class<?> clazz, String loader) {
        Arrays.stream(clazz.getMethods()).forEach(it -> this.tryAddMethod(this.data, loader, (Method)it));
    }

    void attemptRegistration(IBracketParserRegistrationHandler handler) {
        this.validateBrackets(this.data);
        this.register(this.data, handler);
        this.data.clear();
    }

    private void tryAddMethod(Map<String, BracketData> data, String loader, Method method) {
        BracketData bracketData = data.computeIfAbsent(loader, it -> new BracketData());
        if (method.isAnnotationPresent(BracketResolver.class)) {
            this.addBracketResolver(bracketData, method);
        }
        if (method.isAnnotationPresent(BracketDumper.class)) {
            this.addBracketDumper(bracketData.brackets(), method);
        }
        if (method.isAnnotationPresent(BracketValidator.class)) {
            this.addBracketValidator(bracketData.brackets(), method);
        }
    }

    private void addBracketResolver(BracketData data, Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.LOGGER.warn("Method '{}' is marked as a bracket resolver, but it is not public and static.", (Object)method.toString());
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        String name = method.getAnnotation(BracketResolver.class).value();
        if (parameters.length != 1 || !parameters[0].equals(String.class)) {
            CraftTweakerAPI.LOGGER.error("Method '{}' is marked as a bracket resolver, but it does not have a String as it's only parameter.", (Object)method.toString());
            return;
        }
        if (data.brackets().getOrDefault(name, BracketHandle.EMPTY).resolver() != null) {
            Method current = data.brackets().get(name).resolver();
            CraftTweakerAPI.LOGGER.error("Bracket resolver '{}' was already registered: current {}, attempt {}", (Object)name, (Object)current, (Object)method);
            return;
        }
        this.updateBracketHandle(data.brackets(), name, it -> it.resolver(method));
        Class<?> cls = method.getDeclaringClass();
        String clsName = cls.isAnnotationPresent(ZenCodeType.Name.class) ? cls.getAnnotation(ZenCodeType.Name.class).value() : cls.getCanonicalName();
        data.packageLookup().put((Object)clsName.split("\\.", 2)[0], (Object)name);
    }

    private void addBracketDumper(Map<String, BracketHandle> targetMap, Method method) {
        ParameterizedType param;
        Type type;
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.LOGGER.warn("Method '{}' is marked as a bracket dumper, but it is not public and static.", (Object)method.toString());
            return;
        }
        if (method.getParameterCount() != 0) {
            CraftTweakerAPI.LOGGER.warn("Method '{}' is marked as bracket dumper but does not have 0 parameters.", (Object)method.toString());
            return;
        }
        if (!Collection.class.isAssignableFrom(method.getReturnType()) || !((type = method.getGenericReturnType()) instanceof ParameterizedType) || (param = (ParameterizedType)type).getActualTypeArguments()[0] != String.class) {
            CraftTweakerAPI.LOGGER.warn("Method '{}' is marked as bracket dumper but does not have 'Collection<String>' as return type.", (Object)method.toGenericString());
            return;
        }
        BracketDumper annotation = method.getAnnotation(BracketDumper.class);
        String name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, annotation.value());
        String subCommand = annotation.subCommandName().isEmpty() ? null : annotation.subCommandName();
        String fileName = annotation.fileName().isEmpty() ? null : annotation.fileName();
        this.updateBracketHandle(targetMap, name, it -> it.dumper(subCommand, fileName, method));
    }

    private void addBracketValidator(Map<String, BracketHandle> targetMap, Method method) {
        if (!Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
            CraftTweakerAPI.LOGGER.warn("Method '{}' is marked as a bracket validator, but it is not public and static.", (Object)method.toString());
            return;
        }
        BracketValidator validator = method.getAnnotation(BracketValidator.class);
        String name = validator.value();
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length != 1 || !parameters[0].equals(String.class)) {
            CraftTweakerAPI.LOGGER.error("Method '{}' is marked as a bracket validator, but it does not have a String as it's only parameter.", (Object)method.toString());
            return;
        }
        if (targetMap.getOrDefault(name, BracketHandle.EMPTY).validator() != null) {
            Method current = targetMap.get(name).resolver();
            CraftTweakerAPI.LOGGER.error("Bracket resolver '{}' was already registered: current {}, attempt {}", (Object)name, (Object)current, (Object)method);
            return;
        }
        if (method.getReturnType() != Boolean.TYPE) {
            CraftTweakerAPI.LOGGER.error("Method '{}' is marked as a bracket validator, so it must return a boolean", (Object)method);
            return;
        }
        this.updateBracketHandle(targetMap, name, it -> it.validator(method));
    }

    private void updateBracketHandle(Map<String, BracketHandle> map, String target, UnaryOperator<BracketHandle> operation) {
        map.put(target, (BracketHandle)operation.apply(map.getOrDefault(target, BracketHandle.EMPTY)));
    }

    private void validateBrackets(Map<String, BracketData> data) {
        data.values().stream().map(BracketData::brackets).map(Map::entrySet).flatMap(Collection::stream).filter(it -> ((BracketHandle)it.getValue()).validator() != null).filter(it -> ((BracketHandle)it.getValue()).resolver() == null).map(Map.Entry::getKey).forEach(it -> CraftTweakerAPI.LOGGER.info("BEP '{}' has a validator but no BEP method", it));
    }

    private void register(Map<String, BracketData> data, IBracketParserRegistrationHandler handler) {
        data.entrySet().stream().flatMap(it -> ((BracketData)it.getValue()).brackets().entrySet().stream().map(x -> new FlattenedData((String)it.getKey(), (String)x.getKey(), (BracketHandle)x.getValue()))).forEach(it -> this.register((FlattenedData)it, handler));
    }

    private void register(FlattenedData data, IBracketParserRegistrationHandler handler) {
        handler.registerParserFor(data.loader(), data.name(), data.handle().resolver(), data.handle().validator(), this.convert(data.handle().dumper()));
    }

    private IBracketParserRegistrationHandler.DumperData convert(BracketDumpInfo info) {
        if (info == null) {
            return null;
        }
        return new IBracketParserRegistrationHandler.DumperData(info.subCommandName(), info.outputFileName(), () -> info.dumpMethods().stream().map(this::invoke).flatMap(Collection::stream));
    }

    private Collection<String> invoke(MethodHandle handle) {
        try {
            return handle.invokeExact();
        }
        catch (Throwable e) {
            throw new RuntimeException("Error executing bracket dumper", e);
        }
    }

    private record BracketData(Map<String, BracketHandle> brackets, Multimap<String, String> packageLookup) {
        BracketData() {
            this(new HashMap<String, BracketHandle>(), (Multimap<String, String>)HashMultimap.create());
        }
    }

    private record BracketHandle(Method resolver, Method validator, BracketDumpInfo dumper) {
        public static final BracketHandle EMPTY = new BracketHandle(null, null, null);

        BracketHandle resolver(Method resolver) {
            return new BracketHandle(resolver, this.validator, this.dumper);
        }

        BracketHandle validator(Method validator) {
            return new BracketHandle(this.resolver, validator, this.dumper);
        }

        BracketHandle dumper(String subCommandName, String outputFileName, Method dumper) {
            return new BracketHandle(this.resolver, this.validator, (this.dumper != null ? this.dumper : new BracketDumpInfo(subCommandName, outputFileName)).method(dumper));
        }
    }

    private record FlattenedData(String loader, String name, BracketHandle handle) {
    }

    private record BracketDumpInfo(String subCommandName, String outputFileName, List<MethodHandle> dumpMethods) {
        BracketDumpInfo(String subCommandName, String outputFileName) {
            this(subCommandName, outputFileName, List.of());
        }

        BracketDumpInfo method(Method dumper) {
            return new BracketDumpInfo(this.subCommandName, this.outputFileName, Stream.concat(this.dumpMethods().stream(), Stream.of(this.lookup(dumper))).toList());
        }

        private MethodHandle lookup(Method method) {
            try {
                return MethodHandles.publicLookup().unreflect(method);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

