/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.crafttweaker;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.MirrorAxis;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.fun.RecipeFunction2D;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.recipe.type.CTShapedRecipeBase;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;

@IRecipeHandler.For(value=CTShapedRecipeBase.class)
public final class CTShapedRecipeHandler
implements IRecipeHandler<CTShapedRecipeBase> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super CTShapedRecipeBase> manager, CTShapedRecipeBase recipe) {
        return String.format("craftingTable.addShaped(%s, %s, %s%s);", StringUtil.quoteAndEscape(recipe.m_6423_()), recipe.getCtOutput().getCommandString(), Arrays.stream(recipe.getCtIngredients()).map(row -> Arrays.stream(row).map(IIngredient::getCommandString).collect(Collectors.joining(", ", "[", "]"))).collect(Collectors.joining(", ", "[", "]")), recipe.getFunction() == null ? "" : ", (usualOut, inputs) => { ... }");
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super CTShapedRecipeBase> manager, CTShapedRecipeBase firstRecipe, U secondRecipe) {
        return Services.PLATFORM.doCraftingTableRecipesConflict(manager, (Recipe<?>)firstRecipe, secondRecipe);
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super CTShapedRecipeBase> manager, CTShapedRecipeBase recipe) {
        int width = recipe.getRecipeWidth();
        int height = recipe.getRecipeHeight();
        RecipeFunction2D function = recipe.getFunction();
        List<IIngredient> ingredients = this.flatten(recipe.getCtIngredients(), width, height);
        IDecomposedRecipe decomposedRecipe = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D, Pair.of((Object)width, (Object)height)).with(BuiltinRecipeComponents.Metadata.MIRROR_AXIS, recipe.getMirrorAxis()).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredients).with(BuiltinRecipeComponents.Output.ITEMS, recipe.getCtOutput()).build();
        if (function != null) {
            decomposedRecipe.set(BuiltinRecipeComponents.Processing.FUNCTION_2D, function);
        }
        return Optional.of(decomposedRecipe);
    }

    @Override
    public Optional<CTShapedRecipeBase> recompose(IRecipeManager<? super CTShapedRecipeBase> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        Pair<Integer, Integer> size = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.SHAPE_SIZE_2D);
        MirrorAxis axis = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.MIRROR_AXIS);
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        List<RecipeFunction2D> function = recipe.get(BuiltinRecipeComponents.Processing.FUNCTION_2D);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        int width = (Integer)size.getFirst();
        int height = (Integer)size.getSecond();
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid shape size: bounds must be positive but got " + size);
        }
        if (width * height != ingredients.size()) {
            throw new IllegalArgumentException("Invalid shape size: incompatible with ingredients, got " + size + " with " + ingredients.size());
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty item");
        }
        IIngredient[][] matrix = this.inflate(ingredients, width, height);
        RecipeFunction2D recipeFunction = function == null ? null : function.get(0);
        return Optional.of(Services.REGISTRY.createCTShapedRecipe(name.m_135815_(), output, matrix, axis, recipeFunction));
    }

    private List<IIngredient> flatten(IIngredient[][] ingredients, int width, int height) {
        int size = width * height;
        List<IIngredient> flattened = Arrays.asList(new IIngredient[size]);
        for (int i = 0; i < size; ++i) {
            flattened.set(i, ingredients[i / width][i % width]);
        }
        return flattened;
    }

    private IIngredient[][] inflate(List<IIngredient> flattened, int width, int height) {
        IIngredient[][] inflated = new IIngredient[width][height];
        int s = flattened.size();
        for (int i = 0; i < s; ++i) {
            inflated[i / width][i % width] = flattened.get(i);
        }
        return inflated;
    }
}

