/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;

@IRecipeHandler.For.Container(value={@IRecipeHandler.For(value=BlastingRecipe.class), @IRecipeHandler.For(value=CampfireCookingRecipe.class), @IRecipeHandler.For(value=SmeltingRecipe.class), @IRecipeHandler.For(value=SmokingRecipe.class)})
public final class CookingRecipeHandler
implements IRecipeHandler<AbstractCookingRecipe> {
    private static final Map<RecipeType<?>, Pair<String, CookingRecipeFactory<?>>> LOOKUP = ImmutableMap.builder().put((Object)RecipeType.f_44109_, (Object)Pair.of((Object)"blastFurnace", BlastingRecipe::new)).put((Object)RecipeType.f_44111_, (Object)Pair.of((Object)"campfire", CampfireCookingRecipe::new)).put((Object)RecipeType.f_44108_, (Object)Pair.of((Object)"furnace", SmeltingRecipe::new)).put((Object)RecipeType.f_44110_, (Object)Pair.of((Object)"smoker", SmokingRecipe::new)).build();

    @Override
    public String dumpToCommandString(IRecipeManager<? super AbstractCookingRecipe> manager, AbstractCookingRecipe recipe) {
        return String.format("%s.addRecipe(%s, %s, %s, %s, %s);", LOOKUP.get(recipe.m_6671_()).getFirst(), StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IIngredient.fromIngredient((Ingredient)recipe.m_7527_().get(0)).getCommandString(), Float.valueOf(recipe.m_43750_()), recipe.m_43753_());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super AbstractCookingRecipe> manager, AbstractCookingRecipe firstRecipe, U secondRecipe) {
        return IngredientUtil.canConflict((Ingredient)firstRecipe.m_7527_().get(0), (Ingredient)secondRecipe.m_7527_().get(0));
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super AbstractCookingRecipe> manager, AbstractCookingRecipe recipe) {
        IIngredient ingredient = IIngredient.fromIngredient((Ingredient)recipe.m_7527_().get(0));
        IDecomposedRecipe decomposition = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Metadata.GROUP, recipe.m_6076_()).with(BuiltinRecipeComponents.Input.INGREDIENTS, ingredient).with(BuiltinRecipeComponents.Processing.TIME, recipe.m_43753_()).with(BuiltinRecipeComponents.Output.EXPERIENCE, Float.valueOf(recipe.m_43750_())).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.m_8043_())).build();
        return Optional.of(decomposition);
    }

    @Override
    public Optional<AbstractCookingRecipe> recompose(IRecipeManager<? super AbstractCookingRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        String group = recipe.getOrThrowSingle(BuiltinRecipeComponents.Metadata.GROUP);
        IIngredient input = recipe.getOrThrowSingle(BuiltinRecipeComponents.Input.INGREDIENTS);
        int cookTime = recipe.getOrThrowSingle(BuiltinRecipeComponents.Processing.TIME);
        float experience = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.EXPERIENCE).floatValue();
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (input.isEmpty()) {
            throw new IllegalArgumentException("Invalid input: empty ingredient");
        }
        if (cookTime <= 0) {
            throw new IllegalArgumentException("Invalid cooking time: less than min allowed 1: " + cookTime);
        }
        if (experience < 0.0f) {
            throw new IllegalArgumentException("Invalid experience: less than min allowed 0:" + experience);
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid output: empty stack");
        }
        CookingRecipeFactory factory = (CookingRecipeFactory)LOOKUP.get(manager.getRecipeType()).getSecond();
        return Optional.of(factory.create(name, group, input.asVanillaIngredient(), output.getInternal(), experience, cookTime));
    }

    @FunctionalInterface
    private static interface CookingRecipeFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

