/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.recipe.handler.type.vanilla;

import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.BuiltinRecipeComponents;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandlerRegistry;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.crafttweaker.api.util.IngredientUtil;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.blamejared.crafttweaker.api.util.StringUtil;
import com.blamejared.crafttweaker.mixin.common.access.recipe.AccessUpgradeRecipe;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.UpgradeRecipe;

@IRecipeHandler.For(value=UpgradeRecipe.class)
public final class SmithingRecipeHandler
implements IRecipeHandler<UpgradeRecipe> {
    @Override
    public String dumpToCommandString(IRecipeManager<? super UpgradeRecipe> manager, UpgradeRecipe recipe) {
        return String.format("smithing.addRecipe(%s, %s, %s, %s);", StringUtil.quoteAndEscape(recipe.m_6423_()), ItemStackUtil.getCommandString(recipe.m_8043_()), IIngredient.fromIngredient(((AccessUpgradeRecipe)recipe).crafttweaker$getBase()).getCommandString(), IIngredient.fromIngredient(((AccessUpgradeRecipe)recipe).crafttweaker$getAddition()).getCommandString());
    }

    @Override
    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super UpgradeRecipe> manager, UpgradeRecipe firstRecipe, U secondRecipe) {
        if (!(secondRecipe instanceof UpgradeRecipe)) {
            return this.redirectNonVanilla(manager, secondRecipe, firstRecipe);
        }
        AccessUpgradeRecipe first = (AccessUpgradeRecipe)firstRecipe;
        AccessUpgradeRecipe second = (AccessUpgradeRecipe)secondRecipe;
        return IngredientUtil.canConflict(first.crafttweaker$getBase(), second.crafttweaker$getBase()) && IngredientUtil.canConflict(first.crafttweaker$getAddition(), second.crafttweaker$getAddition());
    }

    @Override
    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super UpgradeRecipe> manager, UpgradeRecipe recipe) {
        AccessUpgradeRecipe access = (AccessUpgradeRecipe)recipe;
        IIngredient base = IIngredient.fromIngredient(access.crafttweaker$getBase());
        IIngredient addition = IIngredient.fromIngredient(access.crafttweaker$getAddition());
        IDecomposedRecipe decomposed = IDecomposedRecipe.builder().with(BuiltinRecipeComponents.Input.INGREDIENTS, List.of(base, addition)).with(BuiltinRecipeComponents.Output.ITEMS, IItemStack.of(recipe.m_8043_())).build();
        return Optional.of(decomposed);
    }

    @Override
    public Optional<UpgradeRecipe> recompose(IRecipeManager<? super UpgradeRecipe> manager, ResourceLocation name, IDecomposedRecipe recipe) {
        List<IIngredient> ingredients = recipe.getOrThrow(BuiltinRecipeComponents.Input.INGREDIENTS);
        IItemStack output = recipe.getOrThrowSingle(BuiltinRecipeComponents.Output.ITEMS);
        if (ingredients.size() != 2) {
            throw new IllegalArgumentException("Invalid inputs: expected two ingredients for recipe, but got " + ingredients.size() + ": " + ingredients);
        }
        if (ingredients.get(0).isEmpty() || ingredients.get(1).isEmpty()) {
            throw new IllegalArgumentException("Invalid inputs: empty ingredients");
        }
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Invalid outputs: empty item");
        }
        Ingredient base = ingredients.get(0).asVanillaIngredient();
        Ingredient addition = ingredients.get(1).asVanillaIngredient();
        return Optional.of(new UpgradeRecipe(name, base, addition, output.getInternal()));
    }

    private <T extends Recipe<?>> boolean redirectNonVanilla(IRecipeManager<?> manager, T second, UpgradeRecipe first) {
        return IRecipeHandlerRegistry.getHandlerFor(second).doesConflict((IRecipeManager)GenericUtil.uncheck(manager), second, first);
    }
}

