/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.model.fluid;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import slimeknights.mantle.client.model.fluid.FluidCuboid;
import slimeknights.mantle.client.model.util.ColoredBlockModel;
import slimeknights.mantle.client.model.util.SimpleBlockModel;

public class FluidsModel
implements IUnbakedGeometry<FluidsModel> {
    public static final IGeometryLoader<FluidsModel> LOADER = FluidsModel::deserialize;
    private final SimpleBlockModel model;
    private final List<FluidCuboid> fluids;

    public Collection<Material> getMaterials(IGeometryBakingContext owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.model.getMaterials(owner, modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IGeometryBakingContext owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ItemOverrides overrides, ResourceLocation location) {
        BakedModel baked = this.model.bake(owner, bakery, spriteGetter, transform, overrides, location);
        return new Baked(baked, this.fluids);
    }

    public static FluidsModel deserialize(JsonObject json, JsonDeserializationContext context) {
        ColoredBlockModel model = ColoredBlockModel.deserialize(json, context);
        List<FluidCuboid> fluid = FluidCuboid.listFromJson(json, "fluids");
        return new FluidsModel(model, fluid);
    }

    public FluidsModel(SimpleBlockModel model, List<FluidCuboid> fluids) {
        this.model = model;
        this.fluids = fluids;
    }

    public static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final List<FluidCuboid> fluids;

        public Baked(BakedModel originalModel, List<FluidCuboid> fluids) {
            super(originalModel);
            this.fluids = fluids;
        }

        public List<FluidCuboid> getFluids() {
            return this.fluids;
        }
    }
}

