/*
 * Decompiled with CFR 0.152.
 */
package com.teamdurt.netherdungeons.event;

import com.teamdurt.netherdungeons.effect.NDEffects;
import com.teamdurt.netherdungeons.init.NDBlocks;
import com.teamdurt.netherdungeons.init.NDItems;
import com.teamdurt.netherdungeons.sound.NDSounds;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.entity.monster.piglin.PiglinBrute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="netherdungeons")
public class NDEventsHandler {
    @SubscribeEvent
    public static void giveAxeToPiglinBrute(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getEntity().f_19853_.m_5776_() && (entity = event.getEntity()) instanceof PiglinBrute) {
            PiglinBrute entity2 = (PiglinBrute)entity;
            float givingChance = 50.0f;
            if (Math.random() * 100.0 <= (double)givingChance) {
                entity2.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)NDItems.TEMPERED_GOLD_AXE.get()));
            }
        }
    }

    @SubscribeEvent
    public static void giveSwordToWitherSkeleton(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getEntity().f_19853_.m_5776_() && (entity = event.getEntity()) instanceof WitherSkeleton) {
            WitherSkeleton entity2 = (WitherSkeleton)entity;
            float givingChance = 50.0f;
            if (Math.random() * 100.0 <= (double)givingChance) {
                entity2.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)NDItems.WITHER_SKELETON_SWORD.get()));
            }
        }
    }

    @SubscribeEvent
    public static void catchMagmaCube(PlayerInteractEvent.EntityInteract event) {
        MagmaCube entity;
        Entity entity2;
        Player player = event.getEntity();
        if (!player.f_19853_.m_5776_() && (entity2 = event.getTarget()) instanceof MagmaCube && (entity = (MagmaCube)entity2).m_33632_() <= 1) {
            InteractionHand hand;
            if (player.m_21205_().m_150930_(((Block)NDBlocks.MAGMACUBE_LANTERN_EMPTY.get()).m_5456_())) {
                hand = InteractionHand.MAIN_HAND;
                player.m_21011_(InteractionHand.MAIN_HAND, true);
            } else if (player.m_21206_().m_150930_(((Block)NDBlocks.MAGMACUBE_LANTERN_EMPTY.get()).m_5456_())) {
                hand = InteractionHand.OFF_HAND;
                player.m_21011_(InteractionHand.OFF_HAND, true);
            } else {
                return;
            }
            int empty_lanterns_count = player.m_21120_(hand).m_41613_();
            ItemStack lantern_stack = new ItemStack((ItemLike)((Block)NDBlocks.MAGMACUBE_LANTERN.get()).m_5456_());
            if (player.m_7500_()) {
                player.m_36356_(lantern_stack);
            } else if (empty_lanterns_count > 1) {
                player.m_21120_(hand).m_41764_(empty_lanterns_count - 1);
                player.m_36356_(lantern_stack);
            } else {
                player.m_21008_(hand, lantern_stack);
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @SubscribeEvent
    public static void applyCursedBowEffect(LivingAttackEvent event) {
        if (event.getEntity().f_19853_.m_5776_() || event.getEntity() instanceof Player && ((Player)event.getEntity()).m_7500_() || event.getSource().m_7639_() == null || event.getSource().m_7640_() == null || !event.getSource().m_7639_().m_6167_().iterator().hasNext() || !event.getSource().m_7640_().m_6095_().equals(EntityType.f_20548_)) {
            return;
        }
        boolean isKeepBow = ((ItemStack)event.getSource().m_7639_().m_6167_().iterator().next()).m_150930_((Item)NDItems.CURSED_BOW.get());
        if (isKeepBow) {
            event.getEntity().m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100));
        }
    }

    @SubscribeEvent
    public static void applyVampirismEffect(LivingDeathEvent event) {
        if (event.getEntity().f_19853_.m_5776_() || event.getSource().m_7639_() == null) {
            return;
        }
        LivingEntity killer = (LivingEntity)event.getSource().m_7639_();
        LivingEntity entity = event.getEntity();
        if (killer.m_21023_((MobEffect)NDEffects.VAMPIRISM.get())) {
            int effectAmplifier = killer.m_21124_((MobEffect)NDEffects.VAMPIRISM.get()).m_19564_();
            int healPercentage = (effectAmplifier + 1) * 5 + 5;
            float healthToHeal = entity.m_21233_() * (float)healPercentage / 100.0f;
            killer.m_5634_(healthToHeal);
            killer.f_19853_.m_5594_((Player)null, killer.m_20183_(), (SoundEvent)NDSounds.VAMPIRISM.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

