/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.api.ProjectRedAPI;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.transmission.TransmissionAPI;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.data.TransmissionItemModelProvider;
import mrtjp.projectred.transmission.data.TransmissionItemTagsProvider;
import mrtjp.projectred.transmission.data.TransmissionLanguageProvider;
import mrtjp.projectred.transmission.data.TransmissionRecipeProvider;
import mrtjp.projectred.transmission.init.TransmissionClientInit;
import mrtjp.projectred.transmission.init.TransmissionParts;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="projectred_transmission")
public class ProjectRedTransmission {
    public static final String MOD_ID = "projectred_transmission";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_transmission");
    public static final DeferredRegister<MultipartType<?>> PART_TYPES = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_transmission");
    public static final SimpleCreativeTab TRANSMISSION_GROUP = new SimpleCreativeTab("projectred_transmission", WireType.RED_ALLOY::makeStack);

    public ProjectRedTransmission() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> TransmissionClientInit::init);
        ITEMS.register(modEventBus);
        PART_TYPES.register(modEventBus);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStartEvent);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(event.includeClient(), (DataProvider)new TransmissionItemModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new TransmissionLanguageProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new TransmissionItemTagsProvider(generator, fileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new TransmissionRecipeProvider(generator));
    }

    private void onServerStartEvent(ServerAboutToStartEvent event) {
        RedstonePropagator.resetPowerFlags();
    }

    static {
        ProjectRedAPI.transmissionAPI = TransmissionAPI.INSTANCE;
        TransmissionParts.register();
    }
}

