/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.init;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.texture.SpriteRegistryHelper;
import codechicken.microblock.api.MicroHighlightRenderer;
import codechicken.microblock.client.MicroMaterialClientRegistry;
import codechicken.multipart.api.MultipartClientRegistry;
import codechicken.multipart.api.part.render.PartRenderer;
import java.util.Objects;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.client.CenterWirePartRenderer;
import mrtjp.projectred.transmission.client.FaceWirePartRenderer;
import mrtjp.projectred.transmission.client.FramedWireHighlightRenderer;
import mrtjp.projectred.transmission.client.FramedWirePartItemRenderer;
import mrtjp.projectred.transmission.client.WirePartItemRenderer;
import net.covers1624.quack.util.SneakyUtils;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TransmissionClientInit {
    private static final ModelRegistryHelper MODEL_HELPER = new ModelRegistryHelper();

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(TransmissionClientInit::clientSetup);
        SpriteRegistryHelper spriteHelper = new SpriteRegistryHelper(modEventBus);
        for (WireType type : WireType.values()) {
            type.registerTextures(spriteHelper);
        }
    }

    private static void clientSetup(FMLClientSetupEvent event) {
        for (WireType type : WireType.values()) {
            MultipartClientRegistry.register(type.getPartType(), (PartRenderer)((PartRenderer)SneakyUtils.unsafeCast((Object)(type.isCenterPart() ? CenterWirePartRenderer.INSTANCE : FaceWirePartRenderer.INSTANCE))));
            MODEL_HELPER.register(new ModelResourceLocation(Objects.requireNonNull(type.getItemRegistryObject().getId()), "inventory"), (BakedModel)(type.isCenterPart() ? FramedWirePartItemRenderer.INSTANCE : WirePartItemRenderer.INSTANCE));
        }
        MicroMaterialClientRegistry.registerGlobalHighlightRenderer((MicroHighlightRenderer)FramedWireHighlightRenderer.INSTANCE);
    }
}

