/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedVoxelShape;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.api.MicroMaterial;
import codechicken.microblock.api.SlottedHollowConnect;
import codechicken.microblock.init.CBMicroblockModContent;
import codechicken.microblock.item.ItemMicroBlock;
import codechicken.microblock.util.MicroMaterialRegistry;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.api.part.SlottedPart;
import codechicken.multipart.util.PartRayTraceResult;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.core.part.IConnectableCenterPart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseCenterWirePart
extends BaseWirePart
implements IConnectableCenterPart,
NormalOcclusionPart,
SlottedPart,
SlottedHollowConnect {
    public static final Cuboid6[] fOBounds = new Cuboid6[7];
    public static final VoxelShape[] fOShapes = new VoxelShape[7];
    public static final VoxelShape[] fOShapeStates = new VoxelShape[64];
    public static int expandBounds = -1;
    private static final int KEY_CONN_MAP = 1;
    private static final int KEY_MATERIAL = 2;
    private static final int KEY_REMOVE_MATERIAL = 3;
    private int connMap = 0;
    @Nullable
    private MicroMaterial material = null;

    public BaseCenterWirePart(WireType wireType) {
        super(wireType);
    }

    @Nullable
    public MicroMaterial getMaterial() {
        return this.material;
    }

    public int getConnMap() {
        return this.connMap;
    }

    public void setConnMap(int map) {
        this.connMap = map;
    }

    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("connMap", this.connMap);
        if (this.material != null) {
            tag.m_128359_("mat", Objects.requireNonNull(this.material.getRegistryName()).toString());
        }
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.connMap = tag.m_128451_("connMap");
        this.material = tag.m_128441_("mat") ? MicroMaterialRegistry.getMaterial((String)tag.m_128461_("mat")) : null;
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte(this.packedConnMap());
        packet.writeBoolean(this.material != null);
        if (this.material != null) {
            packet.writeRegistryIdDirect(MicroMaterialRegistry.MICRO_MATERIALS, (Object)this.material);
        }
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.connMap = packet.readUByte();
        if (packet.readBoolean()) {
            this.material = (MicroMaterial)packet.readRegistryIdDirect(MicroMaterialRegistry.MICRO_MATERIALS);
        }
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 1: {
                this.connMap = packet.readUByte();
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
            case 2: {
                this.material = (MicroMaterial)packet.readRegistryIdDirect(MicroMaterialRegistry.MICRO_MATERIALS);
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
            case 3: {
                this.material = null;
                if (!this.useStaticRenderer()) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendConnUpdate() {
        this.sendUpdate(1, p -> p.writeByte(this.packedConnMap()));
    }

    protected void sendMaterialUpdate() {
        if (this.material == null) {
            this.sendUpdate(3, p -> {});
        } else {
            this.sendUpdate(2, p -> p.writeRegistryIdDirect(MicroMaterialRegistry.MICRO_MATERIALS, (Object)this.material));
        }
    }

    public int packedConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    @Override
    public void preparePlacement(Direction side) {
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return SoundType.f_56744_;
    }

    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (!this.level().f_46443_ && this.updateOutward()) {
            this.onMaskChanged();
        }
    }

    public void onNeighborBlockChanged(BlockPos from) {
        super.onNeighborBlockChanged(from);
        if (!this.level().f_46443_ && this.updateExternalConns()) {
            this.onMaskChanged();
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.level().f_46443_ && this.updateInward()) {
            this.onMaskChanged();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.level().f_46443_) {
            this.notifyAllExternals();
        }
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        if (this.material != null) {
            return Math.min(0.041666668f, this.material.getStrength(player));
        }
        return 0.041666668f;
    }

    @Override
    public Iterable<ItemStack> getDrops() {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (ItemStack s : super.getDrops()) {
            list.add(s);
        }
        if (this.material != null) {
            list.add(ItemMicroBlock.create((int)0, (int)1, (MicroMaterial)this.material));
        }
        return list;
    }

    public VoxelShape getShape(CollisionContext context) {
        return new IndexedVoxelShape(this.getCollisionShape(context), (Object)0);
    }

    public VoxelShape getCollisionShape(CollisionContext context) {
        int m = 0;
        for (int s = 0; s < 6; ++s) {
            if (!this.maskConnects(s)) continue;
            m |= 1 << s;
        }
        return fOShapeStates[m];
    }

    public VoxelShape getOcclusionShape() {
        return fOShapes[expandBounds >= 0 ? expandBounds : 6];
    }

    public int getHoleSize(int side) {
        return 8;
    }

    public int getSlotMask() {
        return 64;
    }

    public InteractionResult activate(Player player, PartRayTraceResult hit, ItemStack held, InteractionHand hand) {
        MicroMaterial newMat;
        if (super.activate(player, hit, held, hand).m_19080_()) {
            return InteractionResult.SUCCESS;
        }
        if (held.m_41619_() && player.m_6047_() && this.material != null) {
            if (!this.level().f_46443_) {
                if (this.material != null && !player.m_7500_()) {
                    PlacementLib.dropTowardsPlayer((Level)this.level(), (BlockPos)this.pos(), (ItemStack)ItemMicroBlock.create((int)0, (int)1, (MicroMaterial)this.material), (Player)player);
                }
                this.material = null;
                this.sendMaterialUpdate();
            }
            return InteractionResult.SUCCESS;
        }
        if (!(held.m_41619_() || held.m_41720_() != CBMicroblockModContent.MICRO_BLOCK_ITEM.get() || ItemMicroBlock.getFactory((ItemStack)held) != CBMicroblockModContent.FACE_MICROBLOCK_PART.get() || ItemMicroBlock.getSize((ItemStack)held) != 1 || (newMat = ItemMicroBlock.getMaterialFromStack((ItemStack)held)) == null || this.material != null && newMat == this.material)) {
            if (!this.level().f_46443_) {
                if (newMat.isTransparent()) {
                    return InteractionResult.PASS;
                }
                if (this.material != null && !player.m_7500_()) {
                    PlacementLib.dropTowardsPlayer((Level)this.level(), (BlockPos)this.pos(), (ItemStack)ItemMicroBlock.create((int)0, (int)1, (MicroMaterial)this.material), (Player)player);
                }
                this.material = newMat;
                this.sendMaterialUpdate();
                SoundType sound = newMat.getSound();
                if (sound != null) {
                    this.level().m_5594_(null, this.pos(), sound.m_56777_(), SoundSource.BLOCKS, sound.m_56773_() + 0.5f, sound.m_56774_() * 0.8f);
                }
                if (!player.m_7500_()) {
                    held.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean discoverOpen(int s) {
        MultiPart part = this.tile().getSlottedPart(s);
        if (part == null) {
            return true;
        }
        if (part instanceof IConnectable && this.canConnectPart((IConnectable)part, s)) {
            return true;
        }
        expandBounds = s;
        boolean fits = this.tile().canReplacePart((MultiPart)this, (MultiPart)this);
        expandBounds = -1;
        return fits;
    }

    public void onMaskChanged() {
        this.sendConnUpdate();
    }

    static {
        double w = 0.25;
        BaseCenterWirePart.fOBounds[6] = new Cuboid6(0.5 - w, 0.5 - w, 0.5 - w, 0.5 + w, 0.5 + w, 0.5 + w);
        BaseCenterWirePart.fOShapes[6] = VoxelShapeCache.getShape((Cuboid6)fOBounds[6]);
        for (int s = 0; s < 6; ++s) {
            BaseCenterWirePart.fOBounds[s] = new Cuboid6(0.5 - w, 0.0, 0.5 - w, 0.5 + w, 0.5 - w, 0.5 + w).apply(Rotation.sideRotations[s].at(Vector3.CENTER));
            BaseCenterWirePart.fOShapes[s] = VoxelShapeCache.getShape((Cuboid6)fOBounds[s]);
        }
        for (int m = 0; m < 64; ++m) {
            LinkedList<VoxelShape> shapes = new LinkedList<VoxelShape>();
            shapes.add(VoxelShapeCache.getShape((Cuboid6)fOBounds[6]));
            for (int s = 0; s < 6; ++s) {
                if ((m & 1 << s) == 0) continue;
                shapes.add(VoxelShapeCache.getShape((Cuboid6)fOBounds[s]));
            }
            BaseCenterWirePart.fOShapeStates[m] = VoxelShapeCache.merge((ImmutableSet)ImmutableSet.copyOf(shapes));
        }
    }
}

