/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.VoxelShapeCache;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.api.part.FacePart;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.NormalOcclusionPart;
import codechicken.multipart.block.TileMultipart;
import codechicken.multipart.util.PartMap;
import codechicken.multipart.util.PartRayTraceResult;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.PlacementLib;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class BaseFaceWirePart
extends BaseWirePart
implements IConnectableFacePart,
NormalOcclusionPart,
FacePart {
    public static final Cuboid6[][] sBounds = new Cuboid6[3][6];
    public static final Cuboid6[][] oBounds = new Cuboid6[3][6];
    public static final VoxelShape[][] sShapes = new VoxelShape[3][6];
    public static final VoxelShape[][] oShapes = new VoxelShape[3][6];
    private static final int KEY_CONN_MAP = 1;
    private int connMap = 0;
    private byte side = 0;

    public BaseFaceWirePart(WireType wireType) {
        super(wireType);
    }

    public int getConnMap() {
        return this.connMap;
    }

    public void setConnMap(int map) {
        this.connMap = map;
    }

    public int getSide() {
        return this.side & 0xFF;
    }

    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("connMap", this.connMap);
        tag.m_128344_("side", this.side);
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.connMap = tag.m_128451_("connMap");
        this.side = tag.m_128445_("side");
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeInt(this.connMap);
        packet.writeByte((int)this.side);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.connMap = packet.readInt();
        this.side = packet.readByte();
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 1: {
                this.connMap = packet.readInt();
                if (!Configurator.staticWires) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendConnUpdate() {
        this.sendUpdate(1, p -> p.writeInt(this.connMap));
    }

    @Override
    public void preparePlacement(Direction side) {
        this.side = (byte)(side.ordinal() ^ 1);
    }

    public SoundType getPlacementSound(UseOnContext context) {
        return SoundType.f_56744_;
    }

    public void onPartChanged(@Nullable MultiPart part) {
        super.onPartChanged(part);
        if (!this.level().f_46443_ && this.updateOutward()) {
            this.onMaskChanged();
        }
    }

    public void onNeighborBlockChanged(BlockPos from) {
        super.onNeighborBlockChanged(from);
        if (!this.level().f_46443_) {
            if (this.dropIfCantStay()) {
                return;
            }
            if (this.updateExternalConns()) {
                this.onMaskChanged();
            }
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.level().f_46443_ && this.updateInward()) {
            this.onMaskChanged();
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.level().f_46443_) {
            this.notifyAllExternals();
        }
    }

    public float getStrength(Player player, PartRayTraceResult hit) {
        return 0.06666667f;
    }

    public VoxelShape getShape(CollisionContext context) {
        return sShapes[this.getWireType().getThickness()][this.getSide()];
    }

    public VoxelShape getCollisionShape(CollisionContext context) {
        return Shapes.m_83040_();
    }

    public VoxelShape getOcclusionShape() {
        return oShapes[this.getWireType().getThickness()][this.getSide()];
    }

    public int redstoneConductionMap() {
        return 15;
    }

    public int getSlotMask() {
        return 1 << this.getSide();
    }

    private boolean canStay() {
        return PlacementLib.canPlaceWireOnSide((Level)this.level(), (BlockPos)this.pos().m_121945_(Direction.values()[this.getSide()]), (Direction)Direction.values()[this.getSide() ^ 1]);
    }

    protected boolean dropIfCantStay() {
        if (!this.canStay()) {
            this.drop();
            return true;
        }
        return false;
    }

    private void drop() {
        TileMultipart.dropItem((ItemStack)this.getItem(), (Level)this.level(), (Vector3)Vector3.fromTileCenter((BlockEntity)this.tile()));
        this.tile().remPart((MultiPart)this);
    }

    public boolean canConnectCorner(int r) {
        return true;
    }

    public boolean setRenderFlag(IConnectable part) {
        if (part instanceof BaseFaceWirePart) {
            BaseFaceWirePart wire = (BaseFaceWirePart)part;
            if (wire.getWireType().getThickness() == this.getWireType().getThickness()) {
                return this.getSide() < wire.getSide();
            }
            return wire.getWireType().getThickness() > this.getWireType().getThickness();
        }
        return true;
    }

    public boolean discoverOpen(int r) {
        MultiPart edgePart = this.tile().getSlottedPart(PartMap.edgeBetween((int)this.getSide(), (int)IConnectableFacePart.absoluteDir((IConnectableFacePart)this, (int)r)));
        if (edgePart != null) {
            return false;
        }
        MultiPart insidePart = this.tile().getSlottedPart(IConnectableFacePart.absoluteDir((IConnectableFacePart)this, (int)r));
        if (insidePart instanceof IConnectable) {
            return this.canConnectPart((IConnectable)insidePart, r);
        }
        return insidePart == null;
    }

    public void onMaskChanged() {
        this.sendConnUpdate();
    }

    static {
        for (int t = 0; t < 3; ++t) {
            Cuboid6 selection = new Cuboid6(0.0, 0.0, 0.0, 1.0, (double)(t + 2) / 16.0, 1.0).expand(-0.005);
            Cuboid6 occlusion = new Cuboid6(0.25, 0.0, 0.25, 0.75, (double)(t + 2) / 16.0, 0.75);
            for (int s = 0; s < 6; ++s) {
                BaseFaceWirePart.sBounds[t][s] = selection.copy().apply(Rotation.sideRotations[s].at(Vector3.CENTER));
                BaseFaceWirePart.sShapes[t][s] = VoxelShapeCache.getShape((Cuboid6)sBounds[t][s]);
                BaseFaceWirePart.oBounds[t][s] = occlusion.copy().apply(Rotation.sideRotations[s].at(Vector3.CENTER));
                BaseFaceWirePart.oShapes[t][s] = VoxelShapeCache.getShape((Cuboid6)oBounds[t][s]);
            }
        }
    }
}

