/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.vec.Rotation;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.power.IPowerConductorSource;
import mrtjp.projectred.core.power.IPowerConnectable;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseFaceWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class FacePowerWire
extends BaseFaceWirePart
implements IPowerConnectable,
IPowerConductorSource {
    private final List<PowerConductor> connectedConductors = new LinkedList<PowerConductor>();
    private boolean cacheInvalid = true;

    public FacePowerWire(WireType wireType) {
        super(wireType);
    }

    public long getTime() {
        return this.level().m_46467_();
    }

    public List<PowerConductor> getConnectedConductors() {
        if (this.cacheInvalid) {
            this.recacheConductors();
            this.cacheInvalid = false;
        }
        return this.connectedConductors;
    }

    @Override
    public void onMaskChanged() {
        super.onMaskChanged();
        this.cacheInvalid = true;
    }

    @Override
    public void onNeighborBlockChanged(BlockPos from) {
        super.onNeighborBlockChanged(from);
        this.cacheInvalid = true;
    }

    private void recacheConductors() {
        PowerConductor c;
        FaceLookup lookup;
        this.connectedConductors.clear();
        for (int r = 0; r < 4; ++r) {
            if (this.maskConnectsCorner(r)) {
                lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
            } else if (this.maskConnectsStraight(r)) {
                lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
            } else {
                if (!this.maskConnectsInside(r)) continue;
                lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
            }
            PowerConductor c2 = this.retrieveConductor(lookup);
            if (c2 == null) continue;
            this.connectedConductors.add(c2);
        }
        if (this.maskConnectsCenter() && (c = this.retrieveConductor(lookup = FaceLookup.lookupInsideCenter((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide()))) != null) {
            this.connectedConductors.add(c);
        }
    }

    @Nullable
    private PowerConductor retrieveConductor(FaceLookup lookup) {
        if (lookup.part instanceof IPowerConnectable) {
            return ((IPowerConnectable)lookup.part).getConductor(lookup.otherRotation);
        }
        if (lookup.tile instanceof IPowerConnectable) {
            return ((IPowerConnectable)lookup.tile).getConductor(Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation));
        }
        return null;
    }

    public boolean discoverCornerOverride(int absDir) {
        int r = IConnectableFacePart.absoluteRot((IConnectableFacePart)this, (int)absDir);
        FaceLookup lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        if (lookup.tile instanceof IConnectable) {
            return ((IConnectable)lookup.tile).connectCorner((IConnectable)this, this.getSide() ^ 1, Rotation.rotationTo((int)this.getSide(), (int)(absDir ^ 1)));
        }
        return false;
    }

    public boolean discoverStraightOverride(int absDir) {
        int r = IConnectableFacePart.absoluteRot((IConnectableFacePart)this, (int)absDir);
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        if (lookup.tile instanceof IConnectable) {
            return ((IConnectable)lookup.tile).connectStraight((IConnectable)this, absDir ^ 1, Rotation.rotationTo((int)absDir, (int)this.getSide()));
        }
        return false;
    }
}

