/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Rotation;
import codechicken.multipart.api.RedstoneInteractions;
import codechicken.multipart.api.part.MultiPart;
import codechicken.multipart.api.part.redstone.FaceRedstonePart;
import codechicken.multipart.api.part.redstone.RedstonePart;
import codechicken.multipart.trait.extern.RedstoneTile;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.RedstoneFaceLookup;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.part.IPropagationFacePart;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.core.part.IRedstonePropagationPart;
import mrtjp.projectred.core.part.IRedwireEmitter;
import mrtjp.projectred.core.part.IRedwirePart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseFaceWirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;

public abstract class RedwirePart
extends BaseFaceWirePart
implements IRedstonePropagationPart,
IPropagationFacePart,
FaceRedstonePart,
IRedwirePart {
    private static final int KEY_SIGNAL = 10;
    private byte signal = 0;

    public RedwirePart(WireType wireType) {
        super(wireType);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128344_("signal", this.signal);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.signal = tag.m_128445_("signal");
    }

    @Override
    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeByte((int)this.signal);
    }

    @Override
    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.signal = packet.readByte();
    }

    @Override
    protected void read(MCDataInput packet, int key) {
        switch (key) {
            case 10: {
                this.signal = packet.readByte();
                if (!Configurator.staticWires) break;
                this.tile().markRender();
                break;
            }
            default: {
                super.read(packet, key);
            }
        }
    }

    protected void sendSignalUpdate() {
        this.sendUpdate(10, p -> p.writeByte((int)this.signal));
    }

    @Override
    public void onPartChanged(@Nullable MultiPart part) {
        if (!this.level().f_46443_) {
            RedstonePropagator.logCalculation();
            if (this.updateOutward()) {
                this.onMaskChanged();
                RedstonePropagator.propagateTo((IPropagationPart)this, (int)2);
            } else {
                RedstonePropagator.propagateTo((IPropagationPart)this, (int)0);
            }
        }
    }

    @Override
    public void onNeighborBlockChanged(BlockPos from) {
        if (!this.level().f_46443_) {
            if (this.dropIfCantStay()) {
                return;
            }
            RedstonePropagator.logCalculation();
            if (this.updateExternalConns()) {
                this.onMaskChanged();
                RedstonePropagator.propagateTo((IPropagationPart)this, (int)2);
            } else {
                RedstonePropagator.propagateTo((IPropagationPart)this, (int)0);
            }
        }
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!this.level().f_46443_) {
            RedstonePropagator.propagateTo((IPropagationPart)this, (int)0);
        }
    }

    protected int redstoneSignalLevel() {
        return RedstonePropagator.canRedwiresProvidePower() ? ((this.signal & 0xFF) + 16) / 17 : 0;
    }

    public int weakPowerLevel(int side) {
        int r;
        if ((side & 6) != (this.getSide() & 6) && this.maskConnectsInside(r = Rotation.rotationTo((int)this.getSide(), (int)side))) {
            return 0;
        }
        return this.redstoneSignalLevel();
    }

    public boolean canConnectRedstone(int side) {
        return RedstonePropagator.canConnectRedwires();
    }

    public int getFace() {
        return this.getSide();
    }

    @Override
    public boolean discoverOpen(int r) {
        int absDir = IConnectableFacePart.absoluteDir((IConnectableFacePart)this, (int)r);
        RedstoneTile tile = (RedstoneTile)this.tile();
        return (tile.openConnections(absDir) & 1 << Rotation.rotationTo((int)(absDir & 6), (int)this.getSide())) != 0;
    }

    public boolean discoverStraightOverride(int absDir) {
        boolean prevCanConnectRW = RedstonePropagator.canConnectRedwires();
        RedstonePropagator.setCanConnectRedwires((boolean)true);
        boolean discovered = (RedstoneInteractions.otherConnectionMask((LevelReader)this.level(), (BlockPos)this.pos(), (int)absDir, (boolean)false) & RedstoneInteractions.connectionMask((MultiPart)this, (int)absDir)) != 0;
        RedstonePropagator.setCanConnectRedwires((boolean)prevCanConnectRW);
        return discovered;
    }

    public boolean discoverInternalOverride(int r) {
        MultiPart part = this.tile().getSlottedPart(IConnectableFacePart.absoluteDir((IConnectableFacePart)this, (int)r));
        if (part instanceof FaceRedstonePart) {
            return ((FaceRedstonePart)part).canConnectRedstone(this.getSide());
        }
        return false;
    }

    public boolean canConnectPart(IConnectable part, int dir) {
        return part instanceof IRedwireEmitter || part instanceof RedstonePart;
    }

    public void onSignalUpdate() {
        this.sendSignalUpdate();
    }

    public int getSignal() {
        return this.signal & 0xFF;
    }

    public void setSignal(int signal) {
        this.signal = (byte)signal;
    }

    public int calculateSignal() {
        int s;
        RedstonePropagator.setDustProvidesPower((boolean)false);
        RedstonePropagator.setRedwiresProvidePower((boolean)false);
        int signal = 0;
        for (int r = 0; r < 4; ++r) {
            s = 0;
            if (this.maskConnectsCorner(r)) {
                lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = this.resolveSignal(lookup);
            } else if (this.maskConnectsStraight(r)) {
                lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = this.resolveSignal(lookup);
                if (s <= 0) {
                    s = RedstoneFaceLookup.resolveVanillaSignal((FaceLookup)lookup, (MultiPart)this, (boolean)true, (boolean)true);
                }
            } else if (this.maskConnectsInside(r)) {
                lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
                s = this.resolveSignal(lookup);
            }
            signal = Math.max(s, signal);
        }
        if (this.powerUnderside()) {
            Direction face = Direction.values()[this.getSide()];
            s = this.level().m_46681_(this.pos().m_121945_(face), face) * 17;
            signal = Math.max(s, signal);
        }
        if (this.maskConnectsCenter()) {
            FaceLookup lookup = FaceLookup.lookupInsideCenter((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide());
            s = this.resolveSignal(lookup);
            signal = Math.max(s, signal);
        }
        RedstonePropagator.setDustProvidesPower((boolean)true);
        RedstonePropagator.setRedwiresProvidePower((boolean)true);
        return signal;
    }

    public int getRedwireSignal(int dir) {
        return this.getSignal();
    }

    public boolean diminishOnSide(int side) {
        return true;
    }

    protected int resolveSignal(FaceLookup lookup) {
        return RedstoneFaceLookup.resolveSignal((FaceLookup)lookup, (boolean)true);
    }

    protected abstract boolean powerUnderside();
}

