/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication;

import codechicken.lib.gui.SimpleCreativeTab;
import codechicken.multipart.api.MultipartType;
import mrtjp.projectred.fabrication.data.FabricationBlockStateModelProvider;
import mrtjp.projectred.fabrication.data.FabricationBlockTagsProvider;
import mrtjp.projectred.fabrication.data.FabricationItemModelProvider;
import mrtjp.projectred.fabrication.data.FabricationLanguageProvider;
import mrtjp.projectred.fabrication.data.FabricationLootTableProvider;
import mrtjp.projectred.fabrication.data.FabricationRecipeProvider;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import mrtjp.projectred.fabrication.init.FabricationClientInit;
import mrtjp.projectred.fabrication.init.FabricationItems;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.init.FabricationParts;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="projectred_fabrication")
public class ProjectRedFabrication {
    public static final String MOD_ID = "projectred_fabrication";
    public static final Logger LOGGER = LogManager.getLogger((String)"projectred_fabrication");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"projectred_fabrication");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"projectred_fabrication");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"projectred_fabrication");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"projectred_fabrication");
    public static final DeferredRegister<MultipartType<?>> PARTS = DeferredRegister.create((ResourceLocation)MultipartType.MULTIPART_TYPES, (String)"projectred_fabrication");
    public static final SimpleCreativeTab FABRICATION_GROUP = new SimpleCreativeTab("projectred_fabrication", () -> new ItemStack((ItemLike)FabricationBlocks.IC_WORKBENCH_BLOCK.get()));

    public ProjectRedFabrication() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onGatherDataEvent);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> FabricationClientInit::init);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITY_TYPES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        PARTS.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onGatherDataEvent(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        generator.m_236039_(event.includeClient(), (DataProvider)new FabricationBlockStateModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new FabricationItemModelProvider(generator, fileHelper));
        generator.m_236039_(event.includeClient(), (DataProvider)new FabricationLanguageProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new FabricationBlockTagsProvider(generator, fileHelper));
        generator.m_236039_(event.includeServer(), (DataProvider)new FabricationRecipeProvider(generator));
        generator.m_236039_(event.includeServer(), (DataProvider)new FabricationLootTableProvider(generator));
    }

    static {
        FabricationBlocks.register();
        FabricationMenus.register();
        FabricationItems.register();
        FabricationParts.register();
    }
}

