/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.data;

import javax.annotation.Nonnull;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.fabrication.block.FabricationMachineBlock;
import mrtjp.projectred.fabrication.block.ICWorkbenchBlock;
import mrtjp.projectred.fabrication.init.FabricationBlocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class FabricationBlockStateModelProvider
extends BlockStateProvider {
    public FabricationBlockStateModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "projectred_fabrication", exFileHelper);
    }

    @Nonnull
    public String m_6055_() {
        return "ProjectRed-Fabrication Block Models";
    }

    protected void registerStatesAndModels() {
        this.addICWorkbenchVariants((Block)FabricationBlocks.IC_WORKBENCH_BLOCK.get());
        this.addFabricationMachineVariants((Block)FabricationBlocks.PLOTTING_TABLE_BLOCK.get());
        this.addFabricationMachineVariants((Block)FabricationBlocks.LITHOGRAPHY_TABLE_BLOCK.get());
        this.addFabricationMachineVariants((Block)FabricationBlocks.PACKAGING_TABLE_BLOCK.get());
    }

    private void addICWorkbenchVariants(Block block) {
        this.getVariantBuilder(block).partialState().with((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)this.createICWorkbenchModel(block, false)).addModel();
        this.getVariantBuilder(block).partialState().with((Property)ICWorkbenchBlock.BLUEPRINT_PROPERTY, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)this.createICWorkbenchModel(block, true)).addModel();
    }

    private void addFabricationMachineVariants(Block block) {
        this.addRotatableDomedMachineVariants(block, (ModelFile)this.createDomedMachineModelFileForBlock(block, 2), (ModelFile)this.createDomedMachineModelFileForBlock(block, 1), (ModelFile)this.createDomedMachineModelFileForBlock(block, 0));
    }

    private void addRotatableDomedMachineVariants(Block block, ModelFile workingModel, ModelFile chargedModel, ModelFile idleModel) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int r = (Integer)state.m_61143_((Property)ProjectRedBlock.ROTATION);
            boolean isWorking = (Boolean)state.m_61143_((Property)FabricationMachineBlock.WORKING);
            boolean isCharged = (Boolean)state.m_61143_((Property)FabricationMachineBlock.CHARGED);
            ModelFile modelFile = isWorking && isCharged ? workingModel : (isCharged ? chargedModel : idleModel);
            return ConfiguredModel.builder().modelFile(modelFile).rotationY(r * 90).build();
        });
    }

    private BlockModelBuilder createDomedMachineModelFileForBlock(Block block, int chargeState) {
        String textureName = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String modelName = textureName + (String)(chargeState > 0 ? "_state" + chargeState : "");
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(modelName, this.modLoc("block/domed_machine"))).texture("down", this.modLoc("block/" + textureName + "_bottom"))).texture("up", this.modLoc("block/" + textureName + "_top"))).texture("north", this.modLoc("block/" + textureName + "_front_" + chargeState))).texture("south", this.modLoc("block/" + textureName + "_side"))).texture("west", this.modLoc("block/" + textureName + "_side"))).texture("east", this.modLoc("block/" + textureName + "_side"));
    }

    private BlockModelBuilder createICWorkbenchModel(Block block, boolean hasBlueprint) {
        String textureName = ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
        String suffix = hasBlueprint ? "" : "_empty";
        String modelName = textureName + suffix;
        return (BlockModelBuilder)((BlockModelBuilder)this.models().cube(modelName, this.modLoc("block/" + textureName + "_bottom"), this.modLoc("block/" + textureName + "_top" + suffix), this.modLoc("block/" + textureName + "_front" + suffix), this.modLoc("block/" + textureName + "_front" + suffix), this.modLoc("block/" + textureName + "_side" + suffix), this.modLoc("block/" + textureName + "_side" + suffix))).texture("particle", this.modLoc("block/" + textureName + "_front" + suffix));
    }
}

