/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.editor;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICEditorStateMachine;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.IICWorkbenchEditorNetwork;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.BaseTileMap;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.ICTileType;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class ICWorkbenchEditor
implements ICEditorStateMachine.StateMachineCallback {
    public static final Style UNIFORM = Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "uniform"));
    public static final Style UNIFORM_DARK_GRAY = UNIFORM.m_131140_(ChatFormatting.DARK_GRAY);
    public static final Style UNIFORM_GRAY = UNIFORM.m_131140_(ChatFormatting.GRAY);
    public static final Style UNIFORM_RED = UNIFORM.m_131140_(ChatFormatting.RED);
    public static final Style UNIFORM_YELLOW = UNIFORM.m_131140_(ChatFormatting.YELLOW);
    public static final int EDITOR_FORMAT = 1;
    private static final int STREAM_ID_GENERAL = 0;
    private static final int STREAM_ID_TILE_UPDATES = 1;
    private static final int STREAM_ID_FSM = 2;
    private static final int KEY_ADD_TILE = 1;
    private static final int KEY_REMOVE_TILE = 2;
    private static final int KEY_SET_IC_NAME = 3;
    private static final int KEY_TOOL = 10;
    private static final int KEY_CLIENT_SEND_IC_NAME = 11;
    private final IICWorkbenchEditorNetwork network;
    private final BaseTileMap tileMap = new BaseTileMap(this);
    private final ICEditorStateMachine stateMachine = new ICEditorStateMachine(this, this);
    private final ArrayList<IICEditorTool> toolList = ICEditorToolType.createToolList();
    private final List<TileCoord> neighborChangeList = new LinkedList<TileCoord>();
    private boolean isActive = false;
    private String icName = "untitled";

    public ICWorkbenchEditor(IICWorkbenchEditorNetwork network) {
        this.network = network;
        for (IICEditorTool t : this.toolList) {
            t.bindEditor(this);
        }
    }

    public String getIcName() {
        return this.icName;
    }

    public ArrayList<IICEditorTool> getToolList() {
        return this.toolList;
    }

    public BaseTileMap getTileMap() {
        return this.tileMap;
    }

    public ICEditorStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isClientSide() {
        return this.network.isClientSide();
    }

    public void save(CompoundTag tag) {
        ProjectRedFabrication.LOGGER.debug("ICWorkbenchEditor: saving to NBT");
        tag.m_128405_("format", 1);
        tag.m_128379_("active", this.isActive);
        tag.m_128359_("ic_name", this.icName);
        CompoundTag tileMapTag = new CompoundTag();
        this.tileMap.save(tileMapTag);
        tag.m_128365_("tile_map", (Tag)tileMapTag);
        this.stateMachine.save(tag);
    }

    public void load(CompoundTag tag) {
        this.isActive = tag.m_128471_("active");
        this.icName = tag.m_128461_("ic_name");
        this.tileMap.load(tag.m_128469_("tile_map"));
        this.stateMachine.load(tag);
    }

    public void writeDesc(MCDataOutput out) {
        out.writeBoolean(this.isActive);
        out.writeString(this.icName);
        this.tileMap.writeDesc(out);
        this.stateMachine.writeDesc(out);
    }

    public void readDesc(MCDataInput in) {
        this.isActive = in.readBoolean();
        this.icName = in.readString();
        this.tileMap.readDesc(in);
        this.stateMachine.readDesc(in);
    }

    public void onChunkLoad() {
        this.stateMachine.onChunkLoad();
    }

    private void clear() {
        this.tileMap.removeAll();
        this.stateMachine.reset();
        this.icName = "untitled";
    }

    public void readBlueprintTagAndActivate(@Nullable CompoundTag tag) {
        this.clear();
        if (tag != null) {
            this.load(tag);
        }
        this.isActive = true;
    }

    public void writeBlueprintTagAndDeactivate(CompoundTag tag) {
        this.save(tag);
        this.tileMap.getInterfaceSpec().saveTo(tag, "io_spec");
        tag.m_128405_("tile_count", this.tileMap.getTileCount());
        tag.m_128379_("is_built", this.stateMachine.isSimulating());
        this.isActive = false;
        this.clear();
    }

    public void readBufferedStream(MCDataInput in, int streamKey, int frameKey) {
        switch (streamKey) {
            case 0: {
                this.readGeneralStream(in, frameKey);
                break;
            }
            case 1: {
                this.readTileStream(in, frameKey);
                break;
            }
            case 2: {
                this.stateMachine.readStateMachineStream(in, frameKey);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown stream key " + streamKey);
            }
        }
    }

    private void readTileStream(MCDataInput in, int frameKey) {
        TileCoord positionToUpdate = new TileCoord(in.readByte(), in.readByte(), in.readByte());
        short key = in.readUByte();
        Optional<BaseTile> tileToUpdate = this.tileMap.getBaseTile(positionToUpdate);
        if (tileToUpdate.isEmpty() || tileToUpdate.get().getTileType().getID() != frameKey) {
            ProjectRedFabrication.LOGGER.error("Tile Update error: No tile with id " + frameKey + " at position " + positionToUpdate + ". Reading into temporary tile");
            BaseTile tmp = ICTileType.createFromId(frameKey);
            if (tmp == null) {
                ProjectRedFabrication.LOGGER.error("Unknown tile id " + frameKey + " in tile update stream");
            } else {
                tmp.read(in, key);
            }
            return;
        }
        tileToUpdate.get().read(in, key);
    }

    private void readGeneralStream(MCDataInput in, int frameKey) {
        switch (frameKey) {
            case 1: {
                BaseTile tile = Objects.requireNonNull(ICTileType.createFromId(in.readUByte()));
                this.tileMap.addTile(new TileCoord(in.readByte(), in.readByte(), in.readByte()), tile);
                tile.readDesc(in);
                break;
            }
            case 2: {
                this.tileMap.removeTile(new TileCoord(in.readByte(), in.readByte(), in.readByte()));
                break;
            }
            case 3: {
                this.icName = in.readString();
                break;
            }
            case 10: {
                this.toolList.get(in.readUByte()).readPacket(in);
                break;
            }
            case 11: {
                this.icName = in.readString();
                this.network.getBufferedStream(0, 3).writeString(this.icName);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Unknown key " + frameKey + " in general stream");
            }
        }
    }

    public void tick() {
        if (!this.neighborChangeList.isEmpty()) {
            LinkedList<TileCoord> changesRemaining = new LinkedList<TileCoord>(this.neighborChangeList);
            this.neighborChangeList.clear();
            HashSet<TileCoord> tilesNotified = new HashSet<TileCoord>();
            TileCoord next = (TileCoord)changesRemaining.poll();
            while (next != null) {
                if (!tilesNotified.contains(next)) {
                    tilesNotified.add(next);
                    Optional<BaseTile> tile = this.tileMap.getBaseTile(next);
                    tile.ifPresent(BaseTile::onNeighborChanged);
                }
                next = (TileCoord)changesRemaining.poll();
            }
        }
        if (!this.network.isClientSide()) {
            this.stateMachine.onTick(this.network.getGameTime());
        }
    }

    public MCDataOutput getToolStream(IICEditorTool tool) {
        MCDataOutput out = this.network.getBufferedStream(0, 10);
        out.writeByte(tool.getToolType().ordinal());
        return out;
    }

    public MCDataOutput getTileStream(BaseTile tile, int key) {
        MCDataOutput out = this.network.getBufferedStream(1, tile.getTileType().getID());
        out.writeByte(tile.getPos().x).writeByte(tile.getPos().y).writeByte(tile.getPos().z);
        out.writeByte(key);
        return out;
    }

    public MCDataOutput getStateMachineStream(int key) {
        return this.network.getBufferedStream(2, key);
    }

    public long getGameTime() {
        return this.network.getGameTime();
    }

    public void addTile(BaseTile tile, TileCoord pos) {
        if (this.network.isClientSide()) {
            throw new RuntimeException("Tiles can only be added server-side");
        }
        if (!this.tileMap.addTile(pos, tile)) {
            ProjectRedFabrication.LOGGER.error("Failed to add tile to pos " + pos);
            return;
        }
        tile.onAdded();
        MCDataOutput out = this.network.getBufferedStream(0, 1);
        out.writeByte(tile.getTileType().getID());
        out.writeByte(pos.x).writeByte(pos.y).writeByte(pos.z);
        tile.writeDesc(out);
        this.markTileChange();
    }

    public void removeTile(TileCoord pos) {
        if (this.network.isClientSide()) {
            throw new RuntimeException("Tiles can only be removed server-side");
        }
        Optional<BaseTile> tileToRemove = this.tileMap.getBaseTile(pos);
        if (tileToRemove.isEmpty()) {
            ProjectRedFabrication.LOGGER.error("No tile present to remove at pos " + pos);
            return;
        }
        tileToRemove.get().onRemoved();
        this.tileMap.removeTile(pos);
        MCDataOutput out = this.network.getBufferedStream(0, 2);
        out.writeByte(pos.x).writeByte(pos.y).writeByte(pos.z);
        this.markTileChange();
    }

    public void queueNeighborChange(TileCoord pos) {
        this.neighborChangeList.add(pos);
    }

    public void markTileChange() {
        this.network.markSave();
        if (!this.network.isClientSide()) {
            this.stateMachine.onTileMapChanged();
        }
    }

    public void markDirty() {
        this.network.markSave();
    }

    public void sendNewICName(String name) {
        this.network.getBufferedStream(0, 11).writeString(name);
    }

    @Override
    public void onCompileStart() {
        ProjectRedFabrication.LOGGER.debug("Compiling...");
    }

    @Override
    public void onCompileComplete() {
        ProjectRedFabrication.LOGGER.debug("Compilation complete");
    }

    @Override
    public void onCompileFailed() {
        ProjectRedFabrication.LOGGER.debug("Compilation failed");
    }

    @Override
    public void onSimulationComplete(int changeMask, ICSimulationContainer container) {
        for (Map.Entry<TileCoord, BaseTile> entry : this.tileMap.getBaseTileEntries()) {
            entry.getValue().onSimRegistersChanged(changeMask, container);
        }
    }
}

