/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Transformation;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.tiles.FETile;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.engine.BaseTileMap;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.ICTileType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BaseTile
implements FETile {
    private final ICTileType tileType;
    @Nullable
    private BaseTileMap map;
    @Nullable
    private TileCoord pos;
    @Nullable
    private InteractionZone[] interactionZones;

    public BaseTile(ICTileType tileType) {
        this.tileType = tileType;
    }

    public void bindMap(BaseTileMap map, TileCoord pos) {
        this.map = map;
        this.pos = pos;
    }

    public void unbindMap() {
        this.map = null;
        this.pos = null;
    }

    public BaseTileMap getMap() {
        assert (this.map != null);
        return this.map;
    }

    public ICWorkbenchEditor getEditor() {
        assert (this.map != null);
        return this.map.getEditor();
    }

    public TileCoord getPos() {
        assert (this.pos != null);
        return this.pos;
    }

    public ICTileType getTileType() {
        return this.tileType;
    }

    public abstract void save(CompoundTag var1);

    public abstract void load(CompoundTag var1);

    public abstract void writeDesc(MCDataOutput var1);

    public abstract void readDesc(MCDataInput var1);

    public MCDataOutput getWriteStream(int key) {
        return this.getEditor().getTileStream(this, key);
    }

    public void read(MCDataInput in, int key) {
        switch (key) {
            case 0: {
                this.readDesc(in);
                break;
            }
            default: {
                ProjectRedFabrication.LOGGER.error("Invalid key: " + key);
            }
        }
    }

    public void sendDescUpdate() {
        this.writeDesc(this.getWriteStream(0));
    }

    public void update() {
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onNeighborChanged() {
    }

    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
    }

    public final InteractionZone[] getInteractionZones() {
        if (this.interactionZones == null) {
            LinkedList<InteractionZone> zoneList = new LinkedList<InteractionZone>();
            this.buildInteractionZoneList(zoneList);
            this.interactionZones = zoneList.toArray(new InteractionZone[0]);
        }
        return this.interactionZones;
    }

    public void buildInteractionZoneList(List<InteractionZone> zones) {
    }

    public void buildToolTip(List<Component> toolTip) {
        toolTip.add((Component)Component.m_237115_((String)this.tileType.getUnlocalizedName()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderTile(CCRenderState ccrs, Transformation t, float partialFrame) {
    }
}

