/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.engine.BaseTile;
import mrtjp.projectred.fabrication.engine.gates.ANDGateTile;
import mrtjp.projectred.fabrication.engine.gates.BufferGateTile;
import mrtjp.projectred.fabrication.engine.gates.CounterGateTile;
import mrtjp.projectred.fabrication.engine.gates.IOGateTile;
import mrtjp.projectred.fabrication.engine.gates.MultiplexerGateTile;
import mrtjp.projectred.fabrication.engine.gates.NANDGateTile;
import mrtjp.projectred.fabrication.engine.gates.NORGateTile;
import mrtjp.projectred.fabrication.engine.gates.NOTGateTile;
import mrtjp.projectred.fabrication.engine.gates.ORGateTile;
import mrtjp.projectred.fabrication.engine.gates.PulseGateTile;
import mrtjp.projectred.fabrication.engine.gates.RandomizerGateTile;
import mrtjp.projectred.fabrication.engine.gates.RepeaterGateTile;
import mrtjp.projectred.fabrication.engine.gates.SRLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.SequencerGateTile;
import mrtjp.projectred.fabrication.engine.gates.StateCellGateTile;
import mrtjp.projectred.fabrication.engine.gates.SynchronizerGateTile;
import mrtjp.projectred.fabrication.engine.gates.TimerGateTile;
import mrtjp.projectred.fabrication.engine.gates.ToggleLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.TransparentLatchGateTile;
import mrtjp.projectred.fabrication.engine.gates.XNORGateTile;
import mrtjp.projectred.fabrication.engine.gates.XORGateTile;
import mrtjp.projectred.fabrication.engine.wires.BundledWireTile;
import mrtjp.projectred.fabrication.engine.wires.InsulatedWireTile;
import mrtjp.projectred.fabrication.engine.wires.RedAlloyWireTile;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.transmission.WireType;

public enum ICTileType {
    IO_GATE(0, "projectred_fabrication.tiles.io_gate", IOGateTile::new),
    OR_GATE(16, GateType.OR, ORGateTile::new),
    NOR_GATE(17, GateType.NOR, NORGateTile::new),
    NOT_GATE(18, GateType.NOT, NOTGateTile::new),
    AND_GATE(19, GateType.AND, ANDGateTile::new),
    NAND_GATE(20, GateType.NAND, NANDGateTile::new),
    XOR_GATE(21, GateType.XOR, XORGateTile::new),
    XNOR_GATE(22, GateType.XNOR, XNORGateTile::new),
    BUFFER_GATE(23, GateType.BUFFER, BufferGateTile::new),
    MULTIPLEXER_GATE(24, GateType.MULTIPLEXER, MultiplexerGateTile::new),
    PULSE_GATE(25, GateType.PULSE, PulseGateTile::new),
    REPEATER_GATE(26, GateType.REPEATER, RepeaterGateTile::new),
    RANDOMIZER_GATE(27, GateType.RANDOMIZER, RandomizerGateTile::new),
    SR_LATCH_GATE(28, GateType.SR_LATCH, SRLatchGateTile::new),
    TOGGLE_LATCH_GATE(29, GateType.TOGGLE_LATCH, ToggleLatchGateTile::new),
    TRANSPARENT_LATCH_GATE(30, GateType.TRANSPARENT_LATCH, TransparentLatchGateTile::new),
    TIMER_GATE(31, GateType.TIMER, TimerGateTile::new),
    SEQUENCER_GATE(32, GateType.SEQUENCER, SequencerGateTile::new),
    COUNTER_GATE(33, GateType.COUNTER, CounterGateTile::new),
    STATE_CELL_GATE(34, GateType.STATE_CELL, StateCellGateTile::new),
    SYNCHRONIZER_GATE(35, GateType.SYNCHRONIZER, SynchronizerGateTile::new),
    RED_ALLOY_WIRE(80, WireType.RED_ALLOY, RedAlloyWireTile::new),
    INSULATED_WHITE_WIRE(81, WireType.INSULATED_WHITE, () -> new InsulatedWireTile(0)),
    INSULATED_ORANGE_WIRE(82, WireType.INSULATED_ORANGE, () -> new InsulatedWireTile(1)),
    INSULATED_MAGENTA_WIRE(83, WireType.INSULATED_MAGENTA, () -> new InsulatedWireTile(2)),
    INSULATED_LIGHT_BLUE_WIRE(84, WireType.INSULATED_BLUE, () -> new InsulatedWireTile(3)),
    INSULATED_YELLOW_WIRE(85, WireType.INSULATED_YELLOW, () -> new InsulatedWireTile(4)),
    INSULATED_LIME_WIRE(86, WireType.INSULATED_LIME, () -> new InsulatedWireTile(5)),
    INSULATED_PINK_WIRE(87, WireType.INSULATED_PINK, () -> new InsulatedWireTile(6)),
    INSULATED_GRAY_WIRE(88, WireType.INSULATED_GRAY, () -> new InsulatedWireTile(7)),
    INSULATED_LIGHT_GRAY_WIRE(89, WireType.INSULATED_LIGHT_GRAY, () -> new InsulatedWireTile(8)),
    INSULATED_CYAN_WIRE(90, WireType.INSULATED_CYAN, () -> new InsulatedWireTile(9)),
    INSULATED_PURPLE_WIRE(91, WireType.INSULATED_PURPLE, () -> new InsulatedWireTile(10)),
    INSULATED_BLUE_WIRE(92, WireType.INSULATED_BLUE, () -> new InsulatedWireTile(11)),
    INSULATED_BROWN_WIRE(93, WireType.INSULATED_BROWN, () -> new InsulatedWireTile(12)),
    INSULATED_GREEN_WIRE(94, WireType.INSULATED_GREEN, () -> new InsulatedWireTile(13)),
    INSULATED_RED_WIRE(95, WireType.INSULATED_RED, () -> new InsulatedWireTile(14)),
    INSULATED_BLACK_WIRE(96, WireType.INSULATED_BLACK, () -> new InsulatedWireTile(15)),
    BUNDLED_NEUTRAL_WIRE(100, WireType.BUNDLED_NEUTRAL, () -> new BundledWireTile(-1)),
    BUNDLED_WHITE_WIRE(101, WireType.BUNDLED_WHITE, () -> new BundledWireTile(0)),
    BUNDLED_ORANGE_WIRE(102, WireType.BUNDLED_ORANGE, () -> new BundledWireTile(1)),
    BUNDLED_MAGENTA_WIRE(103, WireType.BUNDLED_MAGENTA, () -> new BundledWireTile(2)),
    BUNDLED_LIGHT_BLUE_WIRE(104, WireType.BUNDLED_LIGHT_BLUE, () -> new BundledWireTile(3)),
    BUNDLED_YELLOW_WIRE(105, WireType.BUNDLED_YELLOW, () -> new BundledWireTile(4)),
    BUNDLED_LIME_WIRE(106, WireType.BUNDLED_LIME, () -> new BundledWireTile(5)),
    BUNDLED_PINK_WIRE(107, WireType.BUNDLED_PINK, () -> new BundledWireTile(6)),
    BUNDLED_GRAY_WIRE(108, WireType.BUNDLED_GRAY, () -> new BundledWireTile(7)),
    BUNDLED_LIGHT_GRAY_WIRE(109, WireType.BUNDLED_LIGHT_GRAY, () -> new BundledWireTile(8)),
    BUNDLED_CYAN_WIRE(110, WireType.BUNDLED_CYAN, () -> new BundledWireTile(9)),
    BUNDLED_PURPLE_WIRE(111, WireType.BUNDLED_PURPLE, () -> new BundledWireTile(10)),
    BUNDLED_BLUE_WIRE(112, WireType.BUNDLED_BLUE, () -> new BundledWireTile(11)),
    BUNDLED_BROWN_WIRE(113, WireType.BUNDLED_BROWN, () -> new BundledWireTile(12)),
    BUNDLED_GREEN_WIRE(114, WireType.BUNDLED_GREEN, () -> new BundledWireTile(13)),
    BUNDLED_RED_WIRE(115, WireType.BUNDLED_RED, () -> new BundledWireTile(14)),
    BUNDLED_BLACK_WIRE(116, WireType.BUNDLED_BLACK, () -> new BundledWireTile(15));

    private static final ICTileType[] VALUES_BY_ID;
    private final int id;
    private final String unlocalizedName;
    private final Supplier<BaseTile> factory;

    private ICTileType(int id, String unlocalizedName, Supplier<BaseTile> factory) {
        this.id = id;
        this.unlocalizedName = unlocalizedName;
        this.factory = factory;
    }

    private ICTileType(int id, GateType gateType, Supplier<BaseTile> factory) {
        this(id, gateType.getItem().m_5524_(), factory);
    }

    private ICTileType(int id, WireType wireType, Supplier<BaseTile> factory) {
        this(id, wireType.getItem().m_5524_(), factory);
    }

    public String getUnlocalizedName() {
        return this.unlocalizedName;
    }

    public BaseTile create() {
        return this.factory.get();
    }

    public int getID() {
        return this.id;
    }

    @Nullable
    public static BaseTile createFromId(int id) {
        if (id < 0 || id >= VALUES_BY_ID.length) {
            return null;
        }
        return VALUES_BY_ID[id].create();
    }

    static {
        VALUES_BY_ID = new ICTileType[121];
        ICTileType[] iCTileTypeArray = ICTileType.values();
        int n = iCTileTypeArray.length;
        for (int i = 0; i < n; ++i) {
            ICTileType type;
            ICTileType.VALUES_BY_ID[type.getID()] = type = iCTileTypeArray[i];
        }
    }
}

