/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Arrays;
import java.util.Set;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class InterfaceSpec {
    private final ICInterfaceType[] sideInterfaces = new ICInterfaceType[4];
    private int redstoneMask = 0;
    private int bundledMask = 0;

    public InterfaceSpec() {
        Arrays.fill((Object[])this.sideInterfaces, (Object)ICInterfaceType.NC);
    }

    public void save(CompoundTag tag) {
        for (int r = 0; r < 4; ++r) {
            tag.m_128344_("if" + r, (byte)this.sideInterfaces[r].getId());
        }
        tag.m_128344_("rmask", (byte)this.redstoneMask);
        tag.m_128344_("bmask", (byte)this.bundledMask);
    }

    public void load(CompoundTag tag) {
        for (int r = 0; r < 4; ++r) {
            this.sideInterfaces[r] = ICInterfaceType.fromId(tag.m_128445_("if" + r) & 0xFF);
        }
        this.redstoneMask = tag.m_128445_("rmask") & 0xFF;
        this.bundledMask = tag.m_128445_("bmask") & 0xFF;
    }

    public void writeDesc(MCDataOutput packet) {
        for (int r = 0; r < 4; ++r) {
            packet.writeByte(this.sideInterfaces[r].getId());
        }
        packet.writeByte(this.bundledMask);
        packet.writeByte(this.redstoneMask);
    }

    public void readDesc(MCDataInput packet) {
        for (int r = 0; r < 4; ++r) {
            this.sideInterfaces[r] = ICInterfaceType.fromId(packet.readByte() & 0xFF);
        }
        this.bundledMask = packet.readByte();
        this.redstoneMask = packet.readByte();
    }

    public void setFromIOTiles(Set<IIOConnectionTile> ioTiles) {
        Arrays.fill((Object[])this.sideInterfaces, (Object)ICInterfaceType.NC);
        this.bundledMask = 0;
        this.redstoneMask = 0;
        for (IIOConnectionTile t : ioTiles) {
            int side = t.getIOSide();
            ICInterfaceType type = t.getInterfaceType();
            int dir = t.isInputIOMode() ? 1 : 16;
            this.sideInterfaces[side] = type;
            switch (type) {
                case REDSTONE: {
                    this.redstoneMask |= dir << side;
                    break;
                }
                case BUNDLED: {
                    this.bundledMask |= dir << side;
                }
            }
        }
    }

    public ICInterfaceType getInterfaceType(int side) {
        return this.sideInterfaces[side];
    }

    public int getInputMask() {
        return (this.redstoneMask | this.bundledMask) & 0xF;
    }

    public int getOutputMask() {
        return (this.redstoneMask | this.bundledMask) >> 4 & 0xF;
    }

    public boolean isInput(int side) {
        return ((this.redstoneMask | this.bundledMask) & 1 << side) != 0;
    }

    public boolean isOutput(int side) {
        return ((this.redstoneMask | this.bundledMask) & 16 << side) != 0;
    }

    public int getRedstoneInputMask() {
        return this.redstoneMask & 0xF;
    }

    public int getRedstoneOutputMask() {
        return this.redstoneMask >> 4 & 0xF;
    }

    public int getBundledInputMask() {
        return this.bundledMask & 0xF;
    }

    public int getBundledOutputMask() {
        return this.bundledMask >> 4 & 0xF;
    }

    public void saveTo(CompoundTag tag, String key) {
        CompoundTag tag1 = new CompoundTag();
        this.save(tag1);
        tag.m_128365_(key, (Tag)tag1);
    }

    public void loadFrom(CompoundTag tag, String key) {
        CompoundTag tag1 = tag.m_128469_(key);
        this.load(tag1);
    }

    public static InterfaceSpec createFrom(CompoundTag tag, String key) {
        CompoundTag tag1 = tag.m_128469_(key);
        InterfaceSpec spec = new InterfaceSpec();
        spec.load(tag1);
        return spec;
    }
}

