/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.gates;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.TransformationList;
import codechicken.lib.vec.Vector3;
import java.util.List;
import java.util.Optional;
import mrtjp.fengine.api.ICAssemblyTile;
import mrtjp.fengine.api.IPathFinder;
import mrtjp.fengine.assemble.PathFinderResult;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.InteractionZone;
import mrtjp.projectred.fabrication.editor.tools.SimpleInteractionZone;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.IIOConnectionTile;
import mrtjp.projectred.fabrication.engine.IRotatableICTile;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.fabrication.engine.gates.ICGateTileType;
import mrtjp.projectred.fabrication.engine.gates.RedstoneGateTile;
import mrtjp.projectred.fabrication.engine.log.MultipleDriversError;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;

public class IOGateTile
extends RedstoneGateTile
implements IIOConnectionTile {
    private static final Cuboid6[] INPUT_TOGGLE_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] DIR_ZONE_BOUNDS = new Cuboid6[4];
    private static final Cuboid6[] COLOR_ZONE_BOUNDS = new Cuboid6[4];
    public static final int COLOUR_PACKET = 6;
    private int regId = 136;
    private byte colour = 0;

    public IOGateTile() {
        super(ICGateTileType.IO);
    }

    @Override
    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128405_("reg", this.regId);
        tag.m_128344_("colour", this.colour);
    }

    @Override
    public void load(CompoundTag tag) {
        super.load(tag);
        this.regId = tag.m_128451_("reg");
        this.colour = tag.m_128445_("colour");
    }

    @Override
    public void writeDesc(MCDataOutput out) {
        super.writeDesc(out);
        out.writeByte((int)this.colour);
    }

    @Override
    public void readDesc(MCDataInput in) {
        super.readDesc(in);
        this.colour = in.readByte();
    }

    @Override
    public void read(MCDataInput in, int key) {
        switch (key) {
            case 6: {
                this.colour = in.readByte();
                break;
            }
            default: {
                super.read(in, key);
            }
        }
    }

    protected void sendColourUpdate() {
        this.getWriteStream(6).writeByte((int)this.colour);
    }

    protected void toggleWorldInput() {
        this.getEditor().getStateMachine().onInputRegistersChanged(this.getIOSide(), i -> (short)(i ^ 1 << this.colour));
    }

    protected void shiftColour(boolean up) {
        this.colour = (byte)((this.colour + (up ? 1 : 15)) % 16);
        this.sendColourUpdate();
        this.getEditor().markTileChange();
    }

    protected void toggleDirection() {
        this.configureShapeAndSend((this.getShape() + 1) % 2);
    }

    protected int getStaticOutputRegister(int colour) {
        return PRFabricationEngine.outputRegisterId(this.getIOSide(), colour);
    }

    protected int getStaticInputRegister(int colour) {
        return PRFabricationEngine.inputRegisterId(this.getIOSide(), colour);
    }

    @Override
    protected boolean canRotate() {
        return false;
    }

    @Override
    public boolean isInputIOMode() {
        return this.getShape() == 0;
    }

    @Override
    public int getIOSide() {
        return this.getRotation();
    }

    @Override
    public ICInterfaceType getInterfaceType() {
        return ICInterfaceType.BUNDLED;
    }

    @Override
    public void buildInteractionZoneList(List<InteractionZone> zones) {
        super.buildInteractionZoneList(zones);
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> INPUT_TOGGLE_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleWorldInput).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)(this.isInputIOMode() ? "projectred_fabrication.interact.sim_input" : "projectred_fabrication.interact.sim_output")).m_7220_((Component)Component.m_237113_((String)(": " + ((this.getState() & 0x44) != 0 ? "0x1" : "0x0")))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> DIR_ZONE_BOUNDS[this.getRotation()]).leftClickAction(this::toggleDirection).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)"projectred_fabrication.interact.io_direction").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)(this.isInputIOMode() ? "projectred_fabrication.interact.io_direction.input" : "projectred_fabrication.interact.io_direction.output"))).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
        zones.add(new SimpleInteractionZone.Builder().bounds(() -> COLOR_ZONE_BOUNDS[this.getRotation()]).leftClickAction(() -> this.shiftColour(true)).rightClickAction(() -> this.shiftColour(false)).tooltip(toolTip -> toolTip.add(Component.m_237115_((String)"projectred_fabrication.interact.io_signal_colour").m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)EnumColour.values()[this.colour & 0xFF].getUnlocalizedName())).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY))).build());
    }

    @Override
    public void onSimRegistersChanged(int rMask, ICSimulationContainer container) {
        int newState;
        int oldState = this.getState();
        if (oldState != (newState = this.pullInputMask(container) & 0xF | this.pullOutputMask(container) << 4)) {
            this.setState(newState);
            this.sendStateUpdate();
        }
    }

    protected int pullInputMask(ICSimulationContainer container) {
        return !this.isInputIOMode() && container.pullRegisterValue(this.regId) != 0 ? 4 : 0;
    }

    protected int pullOutputMask(ICSimulationContainer container) {
        return this.isInputIOMode() && container.pullRegisterValue(this.regId) != 0 ? 4 : 0;
    }

    public int state2() {
        return this.colour & 0xFF;
    }

    @Override
    protected int redstoneOutputMask() {
        return this.isInputIOMode() ? 0 : 4;
    }

    @Override
    protected int redstoneInputMask() {
        return this.isInputIOMode() ? 4 : 0;
    }

    @Override
    public void allocate(ICAssemblyTile.Allocator allocator) {
        this.regId = this.isInputIOMode() ? allocator.allocRegisterID(this.getStaticInputRegister(this.colour)) : 136;
    }

    @Override
    public void locate(IPathFinder pathFinder) {
        if (!this.isInputIOMode()) {
            int absR = this.toAbsoluteRotation(2);
            int absDir = IRotatableICTile.rotationToDir(absR);
            PathFinderResult pfr = pathFinder.doPathFinding((d, p) -> d == absDir);
            if (pfr.outputRegisters.size() > 1) {
                this.getEditor().getStateMachine().getCompilerLog().addProblem(new MultipleDriversError(this.getPos(), pfr.outputRegisters));
            }
            if (!pfr.outputRegisters.isEmpty()) {
                this.regId = pfr.outputRegisters.get(0);
            }
        }
    }

    @Override
    public void registerRemaps(ICAssemblyTile.RemapRegistry remapRegistry) {
        if (!this.isInputIOMode() && this.regId != 136) {
            remapRegistry.addRemap(this.regId, this.getStaticOutputRegister(this.colour));
        }
    }

    @Override
    public void consumeRemaps(ICAssemblyTile.RemapProvider remapProvider) {
        this.regId = remapProvider.getRemappedRegisterID(this.regId);
    }

    @Override
    public void collect(ICAssemblyTile.Collector collector) {
    }

    @Override
    public Optional<Integer> getOutputRegister(int outDir, int outPort) {
        int gateOutputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return this.isInputIOMode() && outDir == gateOutputDir ? Optional.of(this.regId) : Optional.empty();
    }

    @Override
    public Optional<Integer> getInputRegister(int inDir, int inPort) {
        int gateInputDir = IRotatableICTile.rotationToDir(this.toAbsoluteRotation(2));
        return !this.isInputIOMode() && inDir == gateInputDir ? Optional.of(this.regId) : Optional.empty();
    }

    static {
        for (int r = 0; r < 4; ++r) {
            TransformationList t = new Scale(0.0625).with(Rotation.quarterRotations[r].at(Vector3.CENTER));
            IOGateTile.INPUT_TOGGLE_ZONE_BOUNDS[r] = new Cuboid6(1.0, 2.0, 0.0, 15.0, 3.0, 5.0).apply((Transformation)t);
            IOGateTile.DIR_ZONE_BOUNDS[r] = new Cuboid6(2.0, 2.0, 5.0, 6.0, 3.0, 8.0).apply((Transformation)t);
            IOGateTile.COLOR_ZONE_BOUNDS[r] = new Cuboid6(1.0, 2.0, 8.5, 5.0, 4.0, 12.5).apply((Transformation)t);
        }
    }
}

