/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.engine.wires;

import mrtjp.fengine.api.PropagationFunction;
import mrtjp.projectred.fabrication.engine.IBundledConnectableICTile;
import mrtjp.projectred.fabrication.engine.ICTileType;
import mrtjp.projectred.fabrication.engine.IConnectableICTile;
import mrtjp.projectred.fabrication.engine.IInsulatedConnectableICTile;
import mrtjp.projectred.fabrication.engine.wires.ICWireTileType;
import mrtjp.projectred.fabrication.engine.wires.WireTile;
import mrtjp.projectred.transmission.WireType;

public class BundledWireTile
extends WireTile
implements IBundledConnectableICTile {
    public BundledWireTile(int colour) {
        super(colour == -1 ? ICTileType.BUNDLED_NEUTRAL_WIRE : ICWireTileType.BUNDLED_COLOURED[colour].tileType, WireType.values()[WireType.BUNDLED_WHITE.ordinal() + colour]);
    }

    @Override
    public int getBundledColour() {
        return this.getWireType().getColourIdx();
    }

    @Override
    public boolean canConnectTo(IConnectableICTile target, int towardsDir) {
        if (target instanceof IBundledConnectableICTile) {
            int thisColour;
            int targetColour = ((IBundledConnectableICTile)((Object)target)).getBundledColour();
            return targetColour == (thisColour = this.getBundledColour()) || targetColour == -1 || thisColour == -1;
        }
        return target instanceof IInsulatedConnectableICTile;
    }

    @Override
    public PropagationFunction propagationFunc(int inDir, int inPort) {
        return (outDir, outPort) -> outPort == inPort && this.maskConnectsToDir(inDir) && this.maskConnectsToDir(outDir);
    }
}

