/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.vec.Vector3;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nullable;
import mrtjp.fengine.TileCoord;
import mrtjp.fengine.api.ICStepThroughAssembler;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.ICCompilerLog;
import mrtjp.projectred.fabrication.gui.CTNListNode;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import mrtjp.projectred.fabrication.gui.ICRenderTypes;
import mrtjp.projectred.fabrication.gui.ICompileOverlayRenderer;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUISprite;
import mrtjp.projectred.redui.ScrollBarNode;
import mrtjp.projectred.redui.SpriteButtonNode;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class CompileTreeTab
extends AbstractGuiNode
implements ICompileOverlayRenderer {
    public static final Map<ICStepThroughAssembler.AssemblerStepType, String> STEP_TYPE_NAMES;
    public static final Map<ICStepThroughAssembler.AssemblerStepType, String> STEP_TYPE_DESC;
    private static final RedUISprite STEP_OUT_SPRITE;
    private static final RedUISprite STEP_IN_SPRITE;
    private final ICWorkbenchEditor editor;
    private final CTNListNode ctnListNode = new CTNListNode();
    private final Stack<ICCompilerLog.CompileTreeNode> backStack = new Stack();
    @Nullable
    private ICCompilerLog.CompileTreeNode currentNode = null;

    public CompileTreeTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.setSize(91, 134);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.ctnListNode.setPosition(6, 31);
        this.ctnListNode.setSize(79, 95);
        this.addChild((RedUINode)this.ctnListNode);
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.setPosition(77, 31);
        scrollBar.setZPosition(0.2);
        scrollBar.setSize(8, 95);
        scrollBar.setSliderSize(8, 16);
        this.addChild((RedUINode)scrollBar);
        SpriteButtonNode stepOut = new SpriteButtonNode(STEP_OUT_SPRITE);
        stepOut.setClickReceiver(this::stepOut);
        stepOut.setIsDisabledProvider(() -> this.currentNode == null);
        stepOut.setPosition(5, 5);
        stepOut.setSize(16, 16);
        this.addChild((RedUINode)stepOut);
        SpriteButtonNode stepIn = new SpriteButtonNode(STEP_IN_SPRITE);
        stepIn.setClickReceiver(this::stepIn);
        stepIn.setIsDisabledProvider(() -> {
            ICCompilerLog.CompileTreeNode n = this.ctnListNode.getSelectedNode();
            return n == null || n.children.isEmpty();
        });
        stepIn.setPosition(23, 5);
        stepIn.setSize(16, 16);
        this.addChild((RedUINode)stepIn);
    }

    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICWorkbenchCompileTab.TAB_BACKGROUND);
        GuiComponent.m_93133_((PoseStack)stack, (int)this.getFrame().x(), (int)this.getFrame().y(), (float)92.0f, (float)223.0f, (int)this.getFrame().width(), (int)this.getFrame().height(), (int)512, (int)512);
        if (this.currentNode != null) {
            Font fr = this.getRoot().getFontRenderer();
            MutableComponent c = CompileTreeTab.getTitleForCTNNode(this.currentNode).m_6881_().m_130948_(ICWorkbenchEditor.UNIFORM_DARK_GRAY);
            fr.m_92889_(stack, (Component)c, (float)(this.getFrame().x() + 6), (float)(this.getFrame().y() + 21), 0xFFFFFF);
        }
    }

    private void stepIn() {
        ICCompilerLog.CompileTreeNode selected = this.ctnListNode.getSelectedNode();
        if (selected == null) {
            return;
        }
        if (this.currentNode != null) {
            this.backStack.push(this.currentNode);
        }
        this.currentNode = selected;
        this.refreshList();
    }

    private void stepOut() {
        this.currentNode = this.backStack.isEmpty() ? null : this.backStack.pop();
        this.refreshList();
    }

    public void onAddedToParent() {
        this.editor.getStateMachine().getCompilerLog().addTreeChangedListener(this::refreshList);
        this.refreshList();
    }

    private void refreshList() {
        ICCompilerLog log = this.editor.getStateMachine().getCompilerLog();
        if (log.getCurrentStack().isEmpty()) {
            this.currentNode = null;
            this.backStack.clear();
        } else if (this.currentNode == null) {
            this.ctnListNode.setNodeList(this.editor.getStateMachine().getCompilerLog().getRootNodes());
        } else {
            this.ctnListNode.setNodeList(this.currentNode.children);
        }
    }

    @Override
    public void renderOverlay(ICRenderNode renderNode, Vector3 mousePosition, boolean isFirstHit, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        ICCompilerLog.CompileTreeNode node = this.ctnListNode.getSelectedNode();
        if (node == null) {
            node = this.currentNode;
        }
        if (node != null) {
            this.renderOverlayForNode(node, ccrs, getter, matrixStack);
        }
    }

    @Override
    public void buildTooltip(ICRenderNode renderNode, Vector3 mousePosition, List<Component> tooltip) {
    }

    private void renderOverlayForNode(ICCompilerLog.CompileTreeNode node, CCRenderState ccrs, MultiBufferSource getter, PoseStack matrixStack) {
        Vector3 p;
        ccrs.reset();
        ccrs.bind(ICRenderTypes.selectionRenderType, getter, matrixStack);
        ccrs.baseColour = EnumColour.WHITE.rgba(127);
        LinkedList<TileCoord> coords = new LinkedList<TileCoord>();
        for (ICCompilerLog.CompileTreeNode c : node.children) {
            c.getPositionsInTree(coords);
        }
        for (TileCoord pos : coords) {
            p = new Vector3((double)pos.x, (double)pos.y, (double)pos.z);
            ICRenderTypes.renderSelection(ccrs, p, p.copy().add(0.01), 0.1875, 0.125);
        }
        ccrs.baseColour = EnumColour.WHITE.rgba();
        for (TileCoord pos : node.tileCoords) {
            p = new Vector3((double)pos.x, (double)pos.y, (double)pos.z);
            ICRenderTypes.renderSelection(ccrs, p, p.copy().add(0.01), 0.1875, 0.125);
        }
    }

    public static Component getTitleForCTNNode(ICCompilerLog.CompileTreeNode node) {
        String pos = node.tileCoords.isEmpty() ? "" : "[%d, %d, %d]".formatted(node.tileCoords.get((int)0).x, node.tileCoords.get((int)0).y, node.tileCoords.get((int)0).z);
        return switch (node.step) {
            case ICStepThroughAssembler.AssemblerStepType.PHASE1_ALLOC -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_alloc").m_130946_(" " + pos);
            case ICStepThroughAssembler.AssemblerStepType.PHASE2_PATHFIND -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_pathfind").m_130946_(" " + pos);
            case ICStepThroughAssembler.AssemblerStepType.PHASE3_PF_MANIFEST_SEARCH -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_manifest_search").m_130946_(" " + pos);
            case ICStepThroughAssembler.AssemblerStepType.PHASE4_REGISTER_REMAPS -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_add_remaps").m_130946_(" " + pos);
            case ICStepThroughAssembler.AssemblerStepType.PHASE5_CONSUME_REMAPS -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_consume_remaps").m_130946_(" " + pos);
            case ICStepThroughAssembler.AssemblerStepType.PHASE6_COLLECT -> Component.m_237115_((String)"projectred_fabrication.compile.step.merge_tile_map_collect").m_130946_(" " + pos);
            default -> Component.m_237115_((String)STEP_TYPE_NAMES.get((Object)node.step));
        };
    }

    public static void buildTooltipForCTNNode(ICCompilerLog.CompileTreeNode node, List<Component> toolTip) {
        toolTip.add(CompileTreeTab.getTitleForCTNNode(node));
        toolTip.add((Component)Component.m_237115_((String)STEP_TYPE_DESC.get((Object)node.step)).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
        if (!node.registerIds.isEmpty()) {
            toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.unit.registers").m_130946_(":").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            CompileTreeTab.addIntegerList(toolTip, node.registerIds, "R", 2, 4, ICWorkbenchEditor.UNIFORM_GRAY);
        }
        if (!node.gateIds.isEmpty()) {
            toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.unit.gates").m_130946_(":").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            CompileTreeTab.addIntegerList(toolTip, node.gateIds, "G", 2, 4, ICWorkbenchEditor.UNIFORM_GRAY);
        }
        if (!node.registerRemaps.isEmpty()) {
            toolTip.add((Component)Component.m_237115_((String)"projectred_fabrication.unit.remaps").m_130946_(":").m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            CompileTreeTab.addIntegerMap(toolTip, node.registerRemaps, "R", 2, 4, ICWorkbenchEditor.UNIFORM_GRAY);
        }
        if (!node.children.isEmpty()) {
            int r = node.countRegIdsInSubtree();
            int g = node.countGateIdsInSubtree();
            int m = node.countRemapsInSubtree();
            if (r > 0) {
                toolTip.add((Component)Component.m_237113_((String)("  " + r + " ")).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.registers")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
            if (g > 0) {
                toolTip.add((Component)Component.m_237113_((String)("  " + g + " ")).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.gates")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
            if (m > 0) {
                toolTip.add((Component)Component.m_237113_((String)("  " + m + " ")).m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.remaps")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            }
        }
    }

    private static void addIntegerMap(List<Component> toolTip, Map<Integer, Integer> regMap, String prefix, int indent, int limitPerLine, Style style) {
        ArrayList list = FastStream.of(regMap.entrySet()).map(e -> prefix + e.getKey() + " -> " + prefix + e.getValue()).toList();
        CompileTreeTab.addStringList(toolTip, list, indent, limitPerLine, style);
    }

    private static void addIntegerList(List<Component> toolTip, List<Integer> regList, String prefix, int indent, int limitPerLine, Style style) {
        ArrayList list = FastStream.of(regList).map(i -> prefix + i).toList();
        CompileTreeTab.addStringList(toolTip, list, indent, limitPerLine, style);
    }

    private static void addStringList(List<Component> toolTip, List<String> strList, int indent, int limitPerLine, Style style) {
        MutableComponent indentStr = Component.m_237113_((String)" ".repeat(indent));
        if (strList.isEmpty()) {
            toolTip.add((Component)indentStr.m_6881_().m_7220_((Component)Component.m_237115_((String)"projectred_fabrication.unit.none")).m_130948_(ICWorkbenchEditor.UNIFORM_GRAY));
            return;
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        for (String str : strList) {
            s.append(str);
            if (i < strList.size() - 1) {
                s.append(", ");
            }
            if (++i != strList.size() && (i <= 0 || i % limitPerLine != 0)) continue;
            toolTip.add((Component)indentStr.m_6881_().m_130946_(s.toString()).m_130948_(style));
            s = new StringBuilder();
        }
    }

    static {
        EnumMap<ICStepThroughAssembler.AssemblerStepType, String> map = new EnumMap<ICStepThroughAssembler.AssemblerStepType, String>(ICStepThroughAssembler.AssemblerStepType.class);
        map.put(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_TILE_MAPS, "projectred_fabrication.compile.step.check_tile_maps");
        map.put(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_FLAT_MAPS, "projectred_fabrication.compile.step.check_flat_maps");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP, "projectred_fabrication.compile.step.merge_tile_map");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_FLAT_MAP, "projectred_fabrication.compile.step.merge_flat_map");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PRE, "projectred_fabrication.compile.step.merge_tile_map_pre");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE1, "projectred_fabrication.compile.step.merge_tile_map_phase1");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE1_ALLOC, "projectred_fabrication.compile.step.merge_tile_map_alloc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE2, "projectred_fabrication.compile.step.merge_tile_map_phase2");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE2_PATHFIND, "projectred_fabrication.compile.step.merge_tile_map_pathfind");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE3, "projectred_fabrication.compile.step.merge_tile_map_phase3");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE3_PF_MANIFEST_SEARCH, "projectred_fabrication.compile.step.merge_tile_map_manifest_search");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE4, "projectred_fabrication.compile.step.merge_tile_map_phase4");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE4_REGISTER_REMAPS, "projectred_fabrication.compile.step.merge_tile_map_add_remaps");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE5, "projectred_fabrication.compile.step.merge_tile_map_phase5");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE5_CONSUME_REMAPS, "projectred_fabrication.compile.step.merge_tile_map_consume_remaps");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE6, "projectred_fabrication.compile.step.merge_tile_map_phase6");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE6_COLLECT, "projectred_fabrication.compile.step.merge_tile_map_collect");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_POST, "projectred_fabrication.compile.step.merge_tile_map_post");
        STEP_TYPE_NAMES = Collections.unmodifiableMap(map);
        map = new EnumMap(ICStepThroughAssembler.AssemblerStepType.class);
        map.put(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_TILE_MAPS, "projectred_fabrication.compile.step.check_tile_maps.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.CHECK_OPEN_FLAT_MAPS, "projectred_fabrication.compile.step.check_flat_maps.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP, "projectred_fabrication.compile.step.merge_tile_map.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_FLAT_MAP, "projectred_fabrication.compile.step.merge_flat_map.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PRE, "projectred_fabrication.compile.step.merge_tile_map_pre.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE1, "projectred_fabrication.compile.step.merge_tile_map_phase1.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE1_ALLOC, "projectred_fabrication.compile.step.merge_tile_map_alloc.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE2, "projectred_fabrication.compile.step.merge_tile_map_phase2.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE2_PATHFIND, "projectred_fabrication.compile.step.merge_tile_map_pathfind.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE3, "projectred_fabrication.compile.step.merge_tile_map_phase3.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE3_PF_MANIFEST_SEARCH, "projectred_fabrication.compile.step.merge_tile_map_manifest_search.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE4, "projectred_fabrication.compile.step.merge_tile_map_phase4.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE4_REGISTER_REMAPS, "projectred_fabrication.compile.step.merge_tile_map_add_remaps.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE5, "projectred_fabrication.compile.step.merge_tile_map_phase5.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE5_CONSUME_REMAPS, "projectred_fabrication.compile.step.merge_tile_map_consume_remaps.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_PHASE6, "projectred_fabrication.compile.step.merge_tile_map_phase6.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.PHASE6_COLLECT, "projectred_fabrication.compile.step.merge_tile_map_collect.desc");
        map.put(ICStepThroughAssembler.AssemblerStepType.MERGE_TILE_MAP_POST, "projectred_fabrication.compile.step.merge_tile_map_post.desc");
        STEP_TYPE_DESC = Collections.unmodifiableMap(map);
        STEP_OUT_SPRITE = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 335, 41, 14, 14, 512, 512);
        STEP_IN_SPRITE = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 320, 41, 14, 14, 512, 512);
    }

    private class ScrollBar
    extends ScrollBarNode {
        public ScrollBar() {
            super(ScrollBarNode.ScrollAxis.VERTICAL);
        }

        protected void drawSlider(PoseStack stack, Rect sliderFrame) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICWorkbenchCompileTab.TAB_BACKGROUND);
            GuiComponent.m_93133_((PoseStack)stack, (int)sliderFrame.x(), (int)sliderFrame.y(), (float)305.0f, (float)58.0f, (int)sliderFrame.width(), (int)sliderFrame.height(), (int)512, (int)512);
        }

        protected void adjustContent(double scrollPercentage) {
            CompileTreeTab.this.ctnListNode.setScrollPercentage(scrollPercentage);
        }
    }
}

