/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.engine.log.CompileProblem;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchCompileTab;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import mrtjp.projectred.redui.RedUISprite;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ProblemListNode
extends AbstractGuiNode {
    private final List<CompileProblem> problemList = new LinkedList<CompileProblem>();
    private final AbstractGuiNode listParent = new AbstractGuiNode(){};
    private double scroll = 0.0;

    public ProblemListNode() {
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.addChild((RedUINode)this.listParent);
    }

    public void setProblemList(List<CompileProblem> list) {
        this.problemList.clear();
        this.problemList.addAll(list);
        this.refreshListItems();
    }

    private void refreshListItems() {
        this.listParent.removeAllChildren();
        this.listParent.setPosition(0, 0);
        int y = 0;
        for (CompileProblem issue : this.problemList) {
            IssueListItemNode item = new IssueListItemNode(issue);
            item.setPosition(0, y);
            this.listParent.addChild((RedUINode)item);
            y += item.calculateAccumulatedFrame().height();
        }
        this.moveListToScroll();
    }

    public void setScrollPercentage(double scrollPercentage) {
        this.scroll = scrollPercentage;
        this.moveListToScroll();
    }

    private void moveListToScroll() {
        Rect subFrame = this.calculateChildrenFrame();
        if (subFrame.height() <= this.getFrame().height()) {
            return;
        }
        int totalScroll = subFrame.height() - this.getFrame().height();
        int dist = (int)((double)totalScroll * this.scroll);
        this.listParent.setPosition(0, -dist);
    }

    public void onSubTreePreDrawBack() {
        Rect gl11Rect = this.calculateGL11Frame();
        RenderSystem.m_69488_((int)gl11Rect.x(), (int)gl11Rect.y(), (int)gl11Rect.width(), (int)gl11Rect.height());
    }

    public void onSubTreePostDrawBack() {
        RenderSystem.m_69471_();
    }

    private class IssueListItemNode
    extends AbstractGuiNode {
        private static final RedUISprite BACKGROUND_UNSELECTED = new RedUISprite(ICWorkbenchCompileTab.TAB_BACKGROUND, 1, 375, 79, 12, 512, 512);
        private final CompileProblem issue;

        public IssueListItemNode(CompileProblem issue) {
            this.issue = issue;
            this.setSize(79, 12);
        }

        public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
            this.blitSprite(stack, BACKGROUND_UNSELECTED);
            Font fr = this.getRoot().getFontRenderer();
            MutableComponent c = this.issue.getName().m_6881_().m_130948_(ICWorkbenchEditor.UNIFORM);
            float f = this.getFrame().x() + 2;
            float f2 = (float)this.getFrame().y() + (float)this.getFrame().height() / 2.0f;
            Objects.requireNonNull(fr);
            fr.m_92889_(stack, (Component)c, f, f2 - 9.0f / 2.0f, 0xFFFFFF);
        }

        public void drawFront(PoseStack stack, Point mouse, float partialFrame) {
            if (!this.isFirstHit(mouse)) {
                return;
            }
            LinkedList<Component> toolTip = new LinkedList<Component>();
            toolTip.add(this.issue.getName());
            this.issue.buildToolTip(toolTip);
            this.renderTooltip(stack, mouse, toolTip);
        }

        public boolean checkHit(Point absPoint) {
            return super.checkHit(absPoint) && ProblemListNode.this.convertParentRectToScreen(ProblemListNode.this.getFrame()).contains(absPoint);
        }
    }
}

