/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class SelectionGridNode
extends AbstractGuiNode {
    private static final int BUTTON_WIDTH = 16;
    private static final int BUTTON_HEIGHT = 16;
    private static final int BUTTON_U = 495;
    private static final int BUTTON_V = 1;
    private static final int BUTTON_V_SHIFT = 17;
    private final int gridWidth;
    private final int gridHeight;
    private Consumer<Integer> clickFunction = i -> {};
    private Predicate<Integer> selectionCheckFunction = i -> false;
    private BiConsumer<Integer, List<Component>> tooltipBuilder = (i, l) -> {};

    public SelectionGridNode(int gridWidth, int gridHeight) {
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.setSize(gridWidth * 16, gridHeight * 16);
        this.addButtons();
    }

    public void setClickFunction(Consumer<Integer> clickFunction) {
        this.clickFunction = clickFunction;
    }

    public void setTooltipBuilder(BiConsumer<Integer, List<Component>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
    }

    public void setSelectionCheckFunction(Predicate<Integer> selectionCheckFunction) {
        this.selectionCheckFunction = selectionCheckFunction;
    }

    private void addButtons() {
        for (int y = 0; y < this.gridHeight; ++y) {
            for (int x = 0; x < this.gridWidth; ++x) {
                SelectionGridButtonNode button = new SelectionGridButtonNode(x + y * this.gridHeight);
                button.setPosition(x * button.getFrame().width(), y * button.getFrame().height());
                this.addChild((RedUINode)button);
            }
        }
    }

    private class SelectionGridButtonNode
    extends AbstractGuiNode {
        private final int i;

        public SelectionGridButtonNode(int i) {
            this.i = i;
            this.setSize(16, 16);
        }

        public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
            boolean mouseover;
            RenderSystem.m_157456_((int)0, (ResourceLocation)ICWorkbenchScreen.BACKGROUND);
            boolean bl = mouseover = this.getFrame().contains(mouse) && this.isFirstHit(mouse);
            int state = SelectionGridNode.this.selectionCheckFunction.test(this.i) ? 2 : (mouseover ? 1 : 0);
            int x = this.getPosition().x;
            int y = this.getPosition().y;
            int w = this.getFrame().width();
            int h = this.getFrame().height();
            int u = 495;
            int v = 1 + 17 * state;
            GuiComponent.m_93133_((PoseStack)stack, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)512);
        }

        public void drawFront(PoseStack stack, Point mouse, float partialFrame) {
            if (!this.isFirstHit(mouse)) {
                return;
            }
            LinkedList tooltip = new LinkedList();
            SelectionGridNode.this.tooltipBuilder.accept(this.i, tooltip);
            this.renderTooltip(stack, mouse, tooltip);
        }

        public boolean mouseClicked(Point p, int glfwMouseButton, boolean consumed) {
            if (!consumed && this.isFirstHit(p)) {
                this.getRoot().getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
                SelectionGridNode.this.clickFunction.accept(this.i);
                return true;
            }
            return false;
        }
    }
}

