/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.gui.screen;

import codechicken.lib.colour.EnumColour;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mrtjp.projectred.fabrication.editor.ICEditorToolType;
import mrtjp.projectred.fabrication.editor.ICWorkbenchEditor;
import mrtjp.projectred.fabrication.editor.tools.EraseTool;
import mrtjp.projectred.fabrication.editor.tools.GatePlacerTool;
import mrtjp.projectred.fabrication.editor.tools.IICEditorTool;
import mrtjp.projectred.fabrication.editor.tools.InteractTool;
import mrtjp.projectred.fabrication.editor.tools.WirePlacerTool;
import mrtjp.projectred.fabrication.gui.EraserToolTab;
import mrtjp.projectred.fabrication.gui.GatePlacerToolTab;
import mrtjp.projectred.fabrication.gui.ICEditorToolManager;
import mrtjp.projectred.fabrication.gui.ICEditorToolTab;
import mrtjp.projectred.fabrication.gui.ICRenderNode;
import mrtjp.projectred.fabrication.gui.InteractToolTab;
import mrtjp.projectred.fabrication.gui.TabControllerNode;
import mrtjp.projectred.fabrication.gui.WirePlacerToolTab;
import mrtjp.projectred.fabrication.gui.screen.ICWorkbenchScreen;
import mrtjp.projectred.lib.Point;
import mrtjp.projectred.lib.Rect;
import mrtjp.projectred.redui.AbstractGuiNode;
import mrtjp.projectred.redui.RedUINode;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class ICWorkbenchEditTab
extends AbstractGuiNode {
    private final ICWorkbenchEditor editor;
    private final ICEditorToolManager toolManager;
    private final TabControllerNode toolbarNode = new TabControllerNode();

    public ICWorkbenchEditTab(ICWorkbenchEditor editor) {
        this.editor = editor;
        this.toolManager = new ICEditorToolManager(editor.getToolList());
        this.toolManager.addToolSwappedListener(this::onToolSwapped);
        this.setSize(304, 222);
        this.initSubNodes();
    }

    private void initSubNodes() {
        this.toolbarNode.setPosition(286, 24);
        this.toolbarNode.setZPosition(0.1);
        this.addChild((RedUINode)this.toolbarNode);
        for (IICEditorTool tool : this.editor.getToolList()) {
            ICEditorToolTab tab = this.getTabForTool(tool);
            tab.setPosition(305, 0);
            tab.setHidden(true);
            this.toolbarNode.addButtonForTab(tab);
            this.addChild((RedUINode)tab);
        }
        this.toolbarNode.selectInitialTab(0);
        this.toolbarNode.spreadButtonsVertically(1);
        ICRenderNode icRenderNode = new ICRenderNode(this.editor, this.toolManager);
        icRenderNode.setPosition(7, 18);
        icRenderNode.setSize(290, 197);
        this.addChild((RedUINode)icRenderNode);
    }

    private ICEditorToolTab getTabForTool(IICEditorTool tool) {
        if (tool instanceof InteractTool) {
            return new InteractToolTab(this.toolManager, (InteractTool)tool);
        }
        if (tool instanceof EraseTool) {
            return new EraserToolTab(this.toolManager, (EraseTool)tool);
        }
        if (tool instanceof GatePlacerTool) {
            return new GatePlacerToolTab(this.toolManager, (GatePlacerTool)tool);
        }
        if (tool instanceof WirePlacerTool) {
            return new WirePlacerToolTab(this.toolManager, (WirePlacerTool)tool);
        }
        return new ICEditorToolTab(this.toolManager, tool);
    }

    private void onToolSwapped(ICEditorToolType newToolType) {
        this.toolbarNode.openTab(tab -> ((ICEditorToolTab)tab).getTool().getToolType() == newToolType);
    }

    public void drawBack(PoseStack stack, Point mouse, float partialFrame) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)ICWorkbenchScreen.BACKGROUND);
        Rect frame = this.getFrame();
        Font fontRenderer = this.getRoot().getFontRenderer();
        GuiComponent.m_93133_((PoseStack)stack, (int)frame.x(), (int)frame.y(), (float)0.0f, (float)0.0f, (int)frame.width(), (int)frame.height(), (int)512, (int)512);
        fontRenderer.m_92883_(stack, this.editor.getIcName(), (float)(frame.x() + 8), (float)(frame.y() + 6), EnumColour.GRAY.argb());
    }

    public boolean onKeyPressed(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        if (!consumed && !this.isHidden()) {
            return this.toolManager.keyPressed(glfwKeyCode, glfwFlags);
        }
        return false;
    }

    public boolean onKeyReleased(int glfwKeyCode, int glfwScanCode, int glfwFlags, boolean consumed) {
        return this.toolManager.keyReleased(glfwKeyCode, glfwFlags);
    }
}

