/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineContainer;
import mrtjp.projectred.fabrication.item.PhotomaskSetItem;
import mrtjp.projectred.fabrication.item.RoughSiliconWaferItem;
import mrtjp.projectred.fabrication.tile.LithographyTableTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LithographyTableContainer
extends FabricationMachineContainer {
    public static ICCLContainerFactory<LithographyTableContainer> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof LithographyTableTile)) {
            return null;
        }
        return new LithographyTableContainer(inventory, (LithographyTableTile)tile, windowId);
    };
    private final Inventory playerInventory;
    private final LithographyTableTile tile;

    public LithographyTableContainer(Inventory playerInventory, LithographyTableTile tile, int windowId) {
        super((MenuType)FabricationMenus.LITHOGRAPHY_TABLE_CONTAINER.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, x$0 -> this.m_38897_((Slot)x$0));
        this.addLithographyTableInventory();
    }

    private void addLithographyTableInventory() {
        this.m_38897_(new Slot(this.tile.getInventory(), 0, 56, 31));
        this.m_38897_(new Slot(this.tile.getInventory(), 1, 56, 49));
        this.m_38897_((Slot)new TakeOnlySlot(this.tile.getInventory(), 2, 110, 31));
        this.m_38897_((Slot)new TakeOnlySlot(this.tile.getInventory(), 3, 110, 49));
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isOutputs(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isPhotomaskSet(stack) ? !this.moveToPhotomaskInput(stack, false) : (this.isSiliconWafer(stack) ? !this.moveToWaferInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false)))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, true))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 38;
    }

    private boolean isOutputs(int slotIndex) {
        return slotIndex >= 38 && slotIndex < 40;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToPhotomaskInput(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 36, 37, reverse);
    }

    private boolean moveToWaferInput(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 37, 38, reverse);
    }

    private boolean isPhotomaskSet(ItemStack stack) {
        return stack.m_41720_() instanceof PhotomaskSetItem;
    }

    private boolean isSiliconWafer(ItemStack stack) {
        return stack.m_41720_() instanceof RoughSiliconWaferItem;
    }
}

