/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.inventory.container;

import codechicken.lib.inventory.container.ICCLContainerFactory;
import mrtjp.projectred.core.inventory.container.SimpleDataSlot;
import mrtjp.projectred.core.inventory.container.TakeOnlySlot;
import mrtjp.projectred.fabrication.init.FabricationMenus;
import mrtjp.projectred.fabrication.inventory.container.FabricationMachineContainer;
import mrtjp.projectred.fabrication.item.ValidDieItem;
import mrtjp.projectred.fabrication.tile.PackagingTableTile;
import mrtjp.projectred.lib.InventoryLib;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PackagingTableContainer
extends FabricationMachineContainer {
    public static ICCLContainerFactory<PackagingTableContainer> FACTORY = (windowId, inventory, packet) -> {
        BlockEntity tile = inventory.f_35978_.f_19853_.m_7702_(packet.readPos());
        if (!(tile instanceof PackagingTableTile)) {
            return null;
        }
        return new PackagingTableContainer(inventory, (PackagingTableTile)tile, windowId);
    };
    private final Inventory playerInventory;
    private final PackagingTableTile tile;
    protected int problematicSlotMask;

    public PackagingTableContainer(Inventory playerInventory, PackagingTableTile tile, int windowId) {
        super((MenuType)FabricationMenus.PACKAGING_TABLE_CONTAINER.get(), windowId, tile);
        this.playerInventory = playerInventory;
        this.tile = tile;
        InventoryLib.addPlayerInventory((Inventory)playerInventory, (int)8, (int)89, x$0 -> this.m_38897_((Slot)x$0));
        this.addPackagingTableInventory();
        this.m_38895_((DataSlot)new SimpleDataSlot(tile::getProblematicSlotMask, value -> {
            this.problematicSlotMask = value;
        }));
    }

    private void addPackagingTableInventory() {
        InventoryLib.addInventory((Container)this.tile.getInventory(), (int)0, (int)46, (int)22, (int)3, (int)3, x$0 -> this.m_38897_((Slot)x$0));
        this.m_38897_((Slot)new TakeOnlySlot(this.tile.getInventory(), 9, 135, 40));
    }

    public boolean m_6875_(Player player) {
        return !this.tile.m_58901_();
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (!slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack originalStack = stack.m_41777_();
        if (this.isOutput(slotIndex) ? !this.moveToEntireInventory(stack, true) : (this.isHotbar(slotIndex) || this.isPlayerInventory(slotIndex) ? (this.isValidDie(stack) ? !this.moveToDieInput(stack, false) : (this.isPlayerInventory(slotIndex) ? !this.moveToHotbar(stack, false) : !this.moveToPlayerInventory(stack, false))) : this.isInputs(slotIndex) && !this.moveToEntireInventory(stack, false))) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        if (stack.m_41613_() == originalStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        slot.m_142406_(player, stack);
        return originalStack;
    }

    public int getProblematicSlotMask() {
        return this.problematicSlotMask;
    }

    private boolean isHotbar(int slotIndex) {
        return slotIndex >= 27 && slotIndex < 36;
    }

    private boolean isPlayerInventory(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 27;
    }

    private boolean isInputs(int slotIndex) {
        return slotIndex >= 36 && slotIndex < 45;
    }

    private boolean isOutput(int slotIndex) {
        return slotIndex == 45;
    }

    private boolean moveToHotbar(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 27, 36, reverse);
    }

    private boolean moveToPlayerInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 27, reverse);
    }

    private boolean moveToEntireInventory(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 0, 36, reverse);
    }

    private boolean moveToDieInput(ItemStack stack, boolean reverse) {
        return this.m_38903_(stack, 40, 41, reverse);
    }

    private boolean isValidDie(ItemStack stack) {
        return stack.m_41720_() instanceof ValidDieItem;
    }
}

