/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.item;

import java.util.List;
import javax.annotation.Nullable;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.init.FabricationItems;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EtchedSiliconWaferItem
extends Item {
    public EtchedSiliconWaferItem() {
        super(new Item.Properties().m_41491_((CreativeModeTab)ProjectRedFabrication.FABRICATION_GROUP).m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltipList, TooltipFlag tooltipFlag) {
        super.m_7373_(stack, world, tooltipList, tooltipFlag);
        if (stack.m_41783_() == null) {
            return;
        }
        CompoundTag tag = stack.m_41783_();
        tooltipList.add((Component)Component.m_237113_((String)("Name: " + tag.m_128461_("ic_name"))).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237113_((String)("Tile count: " + tag.m_128451_("tilecount"))).m_130940_(ChatFormatting.GRAY));
        byte bmask = tag.m_128445_("bmask");
        tooltipList.add((Component)Component.m_237113_((String)("Input mask: 0x" + Integer.toHexString(bmask & 0xF))).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237113_((String)("Output mask: 0x" + Integer.toHexString(bmask >> 4 & 0xF))).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237113_((String)("Yield: " + tag.m_128459_("yield") * 100.0 + "%")).m_130940_(ChatFormatting.GRAY));
        tooltipList.add((Component)Component.m_237113_((String)("Defects: " + tag.m_128451_("defectCount"))).m_130940_(ChatFormatting.GRAY));
        byte[] defects = tag.m_128463_("defects");
        int gridLen = tag.m_128451_("gridLen");
        for (int y = 0; y < gridLen; ++y) {
            StringBuilder s = new StringBuilder();
            for (int x = 0; x < gridLen; ++x) {
                int i = y * gridLen + x;
                s.append(defects[i] == 0 ? "[-]" : "[X]");
            }
            tooltipList.add((Component)Component.m_237113_((String)("  " + s)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static ItemStack createFromPhotomaskSet(ItemStack photomaskSet, int waferLen, int dieLen, double defectChancePerLen) {
        CompoundTag tag = photomaskSet.m_41783_().m_6426_();
        int gridLen = waferLen / dieLen;
        double defectChancePerDie = (double)dieLen * defectChancePerLen;
        int totalDesigns = gridLen * gridLen;
        int totalDefects = 0;
        byte[] defects = new byte[totalDesigns];
        for (int i = 0; i < totalDesigns; ++i) {
            if (!(Math.random() < defectChancePerDie)) continue;
            defects[i] = 1;
            ++totalDefects;
        }
        double yield = (double)(totalDesigns - totalDefects) / (double)totalDesigns;
        tag.m_128405_("gridLen", gridLen);
        tag.m_128405_("designCount", totalDesigns);
        tag.m_128405_("defectCount", totalDefects);
        tag.m_128347_("yield", yield);
        tag.m_128382_("defects", defects);
        ItemStack output = new ItemStack((ItemLike)FabricationItems.ETCHED_SILICON_WAFER_ITEM.get());
        output.m_41751_(tag);
        return output;
    }
}

