/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.fabrication.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.multipart.util.MultipartPlaceContext;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.fengine.api.ICFlatMap;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.fabrication.ProjectRedFabrication;
import mrtjp.projectred.fabrication.editor.EditorDataUtils;
import mrtjp.projectred.fabrication.engine.ICInterfaceType;
import mrtjp.projectred.fabrication.engine.ICSimulationContainer;
import mrtjp.projectred.fabrication.engine.InterfaceSpec;
import mrtjp.projectred.fabrication.engine.PRFabricationEngine;
import mrtjp.projectred.integration.GateType;
import mrtjp.projectred.integration.part.BundledGatePart;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class FabricatedGatePart
extends BundledGatePart {
    private final ICSimulationContainer simulationContainer = new ICSimulationContainer();
    private final InterfaceSpec ifSpec = new InterfaceSpec();
    private CompoundTag itemStackTag = new CompoundTag();
    private String icName = "untitled";
    private long simulationTimeStart = -1L;
    private int compileFormat = 0;

    public FabricatedGatePart() {
        super(GateType.FABRICATED_GATE);
    }

    public boolean preparePlacement(MultipartPlaceContext context) {
        if (!super.preparePlacement(context)) {
            return false;
        }
        if (context.m_43723_() == null || context.m_43723_().m_9236_().m_5776_()) {
            return false;
        }
        ItemStack stack = context.m_43722_();
        if (stack.m_41619_() || !stack.m_41782_()) {
            ProjectRedFabrication.LOGGER.warn("Gate placement issue: no NBT on gate item");
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (!EditorDataUtils.canFabricate(tag)) {
            ProjectRedFabrication.LOGGER.warn("Gate placement issue: gate item contains invalid data");
            return false;
        }
        this.itemStackTag = EditorDataUtils.createFabricationCopy(tag);
        this.icName = tag.m_128461_("ic_name");
        ICFlatMap flatMap = PRFabricationEngine.instance.deserializeFlatMap(tag.m_128461_("flat_map"));
        this.simulationContainer.setFlatMap(flatMap);
        this.ifSpec.loadFrom(tag, "io_spec");
        this.compileFormat = tag.m_128451_("compile_format");
        return true;
    }

    public void save(CompoundTag tag) {
        super.save(tag);
        tag.m_128365_("item_stack", (Tag)this.itemStackTag);
        tag.m_128359_("ic_name", this.icName);
        tag.m_128356_("sim_time", this.level().m_46467_() - this.simulationTimeStart);
        tag.m_128405_("compile_format", this.compileFormat);
        this.simulationContainer.save(tag);
        this.ifSpec.saveTo(tag, "io_spec");
    }

    public void load(CompoundTag tag) {
        super.load(tag);
        this.itemStackTag = tag.m_128469_("item_stack");
        this.icName = tag.m_128461_("ic_name");
        this.simulationTimeStart = tag.m_128454_("sim_time");
        this.compileFormat = tag.m_128451_("compile_format");
        if (this.compileFormat == 1) {
            this.simulationContainer.load(tag);
        } else {
            ProjectRedFabrication.LOGGER.warn("Fabricated Gate compile format mismatch ({} vs {})", (Object)this.compileFormat, (Object)1);
        }
        this.ifSpec.loadFrom(tag, "io_spec");
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        packet.writeCompoundNBT(this.itemStackTag);
        packet.writeString(this.icName);
        this.ifSpec.writeDesc(packet);
        packet.writeInt(this.compileFormat);
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        this.itemStackTag = Objects.requireNonNullElse(packet.readCompoundNBT(), new CompoundTag());
        this.icName = packet.readString();
        this.ifSpec.readDesc(packet);
        this.compileFormat = packet.readInt();
    }

    public ItemStack getItem() {
        ItemStack stack = super.getItem();
        stack.m_41751_(this.itemStackTag);
        return stack;
    }

    protected int outputMask(int shape) {
        return this.ifSpec.getRedstoneOutputMask();
    }

    protected int inputMask(int shape) {
        return this.ifSpec.getRedstoneInputMask();
    }

    protected int getOutput(int r) {
        if (!this.ifSpec.isOutput(r)) {
            return 0;
        }
        return switch (this.ifSpec.getInterfaceType(r)) {
            default -> throw new IncompatibleClassChangeError();
            case ICInterfaceType.NC, ICInterfaceType.BUNDLED -> 0;
            case ICInterfaceType.REDSTONE -> (this.simulationContainer.getOutput(r) & 1) != 0 ? 15 : 0;
        };
    }

    protected int bundledInputMask(int shape) {
        return this.ifSpec.getBundledInputMask();
    }

    protected int bundledOutputMask(int shape) {
        return this.ifSpec.getBundledOutputMask();
    }

    @Nullable
    protected byte[] getBundledOutput(int r) {
        if (!this.ifSpec.isOutput(r)) {
            return null;
        }
        return switch (this.ifSpec.getInterfaceType(r)) {
            default -> throw new IncompatibleClassChangeError();
            case ICInterfaceType.NC, ICInterfaceType.REDSTONE -> null;
            case ICInterfaceType.BUNDLED -> BundledSignalsLib.unpackDigital(null, (int)this.simulationContainer.getOutput(r));
        };
    }

    public int state2() {
        int rsMask = this.ifSpec.getRedstoneInputMask() | this.ifSpec.getRedstoneOutputMask();
        int analogMask = 0;
        int bundledMask = this.ifSpec.getBundledInputMask() | this.ifSpec.getBundledOutputMask();
        return rsMask & 0xF | (analogMask & 0xF) << 4 | (bundledMask & 0xF) << 8;
    }

    public String getGateName() {
        return this.icName;
    }

    public boolean hasRuntimeError() {
        return this.compileFormat != 1;
    }

    protected void gateLogicOnWorldLoad() {
        this.simulationTimeStart = this.level().m_46467_() - this.simulationTimeStart;
    }

    protected void gateLogicSetup() {
        if (this.simulationTimeStart == -1L) {
            this.simulationTimeStart = this.level().m_46467_();
            this.tile().m_6596_();
        }
    }

    protected void gateLogicOnChange() {
        short[] newInputs = new short[4];
        for (int r = 0; r < 4; ++r) {
            newInputs[r] = this.getModeBasedInput(r);
        }
        int changeMask = this.simulationContainer.setInputs(newInputs);
        if (changeMask != 0) {
            this.setState(this.state() & 0xF0 | this.simulationContainer.inputMask());
            this.onInputChange();
            this.scheduleTick(2);
        }
    }

    protected void gateLogicOnScheduledTick() {
        this.simulationContainer.pushInputs(15);
        this.simulationContainer.simulate();
        int changeMask = this.simulationContainer.pullOutputs();
        if (changeMask != 0) {
            this.setState(this.state() & 0xF | this.simulationContainer.outputMask() << 4);
            this.onOutputChange(changeMask);
        }
        this.gateLogicOnChange();
    }

    protected void gateLogicOnTick() {
        if (!this.level().f_46443_) {
            long simTimeElapsed = this.level().m_46467_() - this.simulationTimeStart;
            this.simulationContainer.setSystemTime(simTimeElapsed);
            this.simulationContainer.pushTime();
            this.simulationContainer.simulate();
            int changeMask = this.simulationContainer.pullOutputs();
            if (changeMask != 0) {
                this.setState(this.state() & 0xF | this.simulationContainer.outputMask() << 4);
                this.onOutputChange(changeMask);
            }
        }
    }

    private short getModeBasedInput(int r) {
        if (!this.ifSpec.isInput(r)) {
            return 0;
        }
        return switch (this.ifSpec.getInterfaceType(r)) {
            default -> throw new IncompatibleClassChangeError();
            case ICInterfaceType.NC -> 0;
            case ICInterfaceType.REDSTONE -> (short)(this.getRedstoneInput(r) != 0 ? 65535 : 0);
            case ICInterfaceType.BUNDLED -> (short)BundledSignalsLib.packDigital((byte[])this.getBundledInput(r));
        };
    }
}

